# 02-gestion – Vue fonctionnelle

Ce document décrira la façon dont la **gestion opérationnelle** est modélisée et perçue dans l’application :
- états avancés (en retard, bloqué, échoué),
- dates / échéances,
- progression numérique,
- et, potentiellement, quantités de ressources matérielles.

## Contexte / Problème

Aujourd’hui, la gestion d’un board repose principalement sur :

- des tags d’état simples (`todo/doing/done`) déposés par le pack Organisation,
- quelques catégories libres,
- des notes dans le contenu.

Cela permet de travailler, mais reste limité pour une **gestion opérationnelle fine** :

- impossible de distinguer clairement :
  - ce qui est en retard,
  - ce qui est bloqué,
  - ce qui a échoué,
- les dates ou échéances ne sont pas encore pleinement modélisées,
- la progression d’une tâche n’est visible qu’au travers des états (`doing` vs `done`),
- la gestion de quantités matérielles (stock, ressources) n’est pas standardisée.

Le pack Gestion vise à :

- enrichir le modèle d’état d’un item,
- introduire des échéances structurées,
- offrir une progression numérique fine,
- préparer un socle pour la gestion de ressources (quantités).

## Parcours utilisateur – Gestion (vue d’ensemble)

1. **Créer et préparer une tâche**
   - Depuis le board, l’utilisateur crée un item.
   - Dans le panneau d’édition de l’item, il :
     - choisit un état de base (`todo/doing/done`),
     - fixe éventuellement une progression initiale (effective/maximale),
     - ajoute des échéances (par catégorie) si nécessaire.
   - La vignette de l’item reflète immédiatement :
     - la barre d’état (todo/doing/done),
     - la barre de progression,
     - les indicateurs de dates importantes.

2. **Suivre un groupe / une phase**
   - L’utilisateur ouvre un container représentant une phase ou un groupe.
   - Dans son panneau, il :
     - peut saisir une progression propre au container,
     - ou s’appuyer sur des relations (ex. “ce container dépend de T1/T2/T3”) qui alimentent une progression agrégée
       définie par des règles.
   - Sur le board, la vignette du container affiche :
     - sa progression,
     - des signaux de retard ou de blocage dérivés de Gestion/Relations/Logique.

3. **Gérer retards, blocages et échecs**
   - Quand une échéance est dépassée sans `done`, la tâche apparaît comme “en retard potentiel” :
     - selon la politique du board, `state/late` est appliqué automatiquement ou laissé à la main.
   - Si une dépendance est bloquée, l’utilisateur voit dans le panneau Relations/Gestion :
     - quels items sont `blocked`,
     - quels items en héritent fonctionnellement.
   - Lorsqu’un objectif est abandonné, l’utilisateur autorisé :
     - applique `state/failed`,
     - conserve ainsi une trace claire de l’échec plutôt qu’une simple tâche “jamais terminée”.

4. **Suivre et ajuster des ressources**
   - L’utilisateur crée un container “Stock” regroupant des items de type ressource.
   - Pour chaque ressource, il renseigne :
     - un type (`resource/*`),
     - une quantité,
     - éventuellement une unité.
   - Des actions Interactions ou des règles Logique peuvent ensuite :
     - consommer ces ressources,
     - alerter sur des seuils,
     - nourrir des vues de synthèse (totaux par type/unité).

## Objectifs fonctionnels

### 2.1. États avancés (retard, bloqué, échoué)

- Introduire des tags système d’état supplémentaires (par ex.) :
  - `state/late` (en retard),
  - `state/blocked` (bloqué),
  - `state/failed` (échoué).
- Clarifier leur rôle :
  - `late` : l’item n’est pas terminé alors qu’une échéance importante est dépassée,
  - `blocked` : l’item ne peut pas avancer pour des raisons externes (dépendances non résolues, manque de ressources…),
  - `failed` : l’objectif de l’item est considéré comme manqué/abandonné.
- Sémantique par défaut :
  - `blocked` est un flag **informatif** (pas de veto moteur) ; l’UI le signale fortement et peut demander une confirmation sur certaines actions (ex. suppression, passage en `done`). Des règles Logique peuvent rendre ce flag bloquant si besoin.
  - `failed` et `done` sont exclusifs (cf. matrice).
- États principaux **exclusifs** : un item peut n’avoir **aucun** état principal, ou **exactement un** parmi `{todo, doing, done, failed}` ; il ne doit jamais en avoir plusieurs en même temps.  
  - `done` et `failed` sont mutuellement exclusifs.
- Flags :
  - `blocked` et `late` **seulement** avec `todo` ou `doing` ; toute transition vers `done/failed` les retire automatiquement.
- Ces états/flags doivent pouvoir :
  - être appliqués manuellement (par l’utilisateur),
  - être appliqués automatiquement (via dates, relations, interactions ou logique),
  - sans jamais créer de combinaison interdite (`done+blocked`, `done+failed`, etc.) : ces commandes sont rejetées.

### 2.2. Dates & échéances

- Permettre d’attacher à un item une ou plusieurs **échéances structurées** :
  - chaque échéance a :
    - un label (texte libre),
    - une catégorie (ex. `start`, `due`, `review`, `deadline`),
    - une date (ou date+heure) effective.
- Règles générales :
  - pour une catégorie donnée, un item a au plus une échéance (pas deux `due` différentes sur le même item),
  - les échéances sont éditables via un panneau dédié dans l’édition de l’item.
- Lier les échéances aux états :
  - ex. si la date actuelle dépasse une échéance de type `deadline` et que l’item n’est pas terminé,
    alors l’item est éligible au tag `state/late` (application manuelle ou automatique via règles).
- Politique `late` configurable par board :
  - `manual-only` (par défaut) : pas d’auto-tag, simple éligibilité + signal,
  - `auto-tag` : application automatique de `state/late` quand la deadline est dépassée si pas `done`,
  - `eligible-only` : warning UI, sans appliquer le tag.
- Par défaut (même sans auto-tag), les échéances dépassées sont signalées visuellement : date en style “retard”, badge “en retard” sur la carte.

### 2.3. Progression numérique

- Chaque item dispose de **deux champs numériques** liés à la progression :
  - une **progression effective** (points réalisés),
  - une **progression maximale** (points totaux pour cet item), bornée à 10 000.
- La progression effective est toujours comprise entre 0 et la progression maximale :
  - 0 = aucun progrès,
  - progression effective = progression maximale = “100 %” pour cet item.
- Progression affichée :
  - si progression connue (`max > 0`) : affichage en pourcentage (ex. “37 %”) avec tooltip “37 / 100”,
  - si progression inconnue : `max` nul/absent, barre neutre ou “N/A”.
- Si la progression maximale change, la progression effective est **rescalée** pour conserver le même ratio puis clampée au nouveau max (arrondi).
- Dans l’édition d’un item :
  - l’utilisateur peut saisir/modifier la progression effective et la progression maximale,
  - des contrôles adaptés (inputs, sliders) facilitent la mise à jour.
- Dans le board :
  - une **barre de progression** apparaît sur la vignette de l’item,
  - visuellement, la barre reflète “progression effective / progression maximale”.
- Dans la configuration standard du pack Gestion, la combinaison `state/done` + progression numérique
  est **strictement cohérente** :
  - si un item possède un état `state/done` et une progression, celle‑ci doit représenter “100 %” (`effective = max`) ;
  - si l’utilisateur tente de poser un `done` incohérent avec la progression (ou l’inverse), la commande est refusée et l’UI doit proposer un raccourci “Terminer” qui met à la fois la progression à son maximum et l’état à `done`.
- La **barre d’état verticale** (qui reflète le tag d’état : todo/doing/done, etc.) peut voir sa **largeur varier**
  en fonction de la progression maximale :
  - en dessous de 10 points, la barre d’état conserve sa largeur initiale,
  - à certains paliers (par ex. 100, 1 000, 10 000), la largeur augmente par steps,
  - cela donne une indication visuelle de “l’importance” relative de l’item.
- La progression est définie **par item**, qu’il soit leaf ou container :
  - il n’y a pas de comportement spécial basé uniquement sur `sys.shape`,
  - la seule agrégation V1 est une **readiness fonctionnelle** = `min` des progressions fonctionnelles de ses dépendances (`rel/depends-on`/`rel/blocks`), jamais par simple structure.

### 2.4. Ressources matérielles

- Introduire la notion d’item “ressource” :
  - un item peut représenter une ressource matérielle (eau, bois, métal, argent, etc.) avec :
    - un **type de ressource**,
    - une **quantité**,
    - éventuellement une **unité** (L, kg, €, …).
- Les types de ressources sont normalisés via une catégorie dédiée de tags système, par exemple :
  - `resource/water`, `resource/wood`, `resource/metal`, `resource/money`, etc.
- Ces types de ressources :
  - sont définis dans un catalogue configurable (similaire aux catégories existantes),
  - peuvent être étendus par l’administrateur (ajout de nouveaux types, avec icônes/couleurs),
  - évitent les problèmes de labels libres incohérents (typos, variations orthographiques).
- La quantité est un champ numérique sur l’item :
  - l’utilisateur peut l’augmenter ou la diminuer (entrées/sorties),
  - les actions Interactions pourront utiliser ce champ pour :
    - consommer une quantité donnée,
    - répartir une ressource entre plusieurs cibles.

## Scénarios d’usage

### 3.1. Suivre l’avancement d’une tâche

- L’utilisateur crée une tâche T, lui donne un titre, des tags, et saisit une progression :
  - au début : progression = 0 (0 %),
  - au fur et à mesure du travail : progression augmente (ex. 3 000, 6 000, 10 000).
- La barre de progression sur la vignette reflète cette avancée.
- Quand progression = 10 000 :
  - dans la configuration standard, l’item est **éligible** à l’état “terminé” (`done`) ;
  - l’UI peut proposer un bouton “Marquer comme terminé” qui :
    - met la progression effective à la valeur maximale si besoin,
    - puis applique `state/done` via une commande dédiée ;
  - si l’utilisateur essaie d’appliquer `done` sans que la progression reflète 100 %, le backend refuse la combinaison et l’UI doit guider vers une mise à jour cohérente.

### 3.2. Suivre l’avancement d’un groupe

- L’utilisateur a un container C contenant plusieurs tâches T1, T2, T3.
- Il veut voir une **progression globale** pour C :
  - il peut saisir directement une progression effective / maximale pour C (comme pour n’importe quel item),
  - et/ou définir, via Relations et Logique, que la progression de C dépend de celle de certaines tâches
    (par exemple en créant des relations “C dépend de T1/T2/T3” et des règles qui agrègent leurs progressions).
- Dans le board :
  - la vignette de C affiche sa barre de progression,
  - l’utilisateur voit rapidement quels groupes avancent, lesquels stagnent.

### 3.3. Gérer les retards

- L’utilisateur définit une échéance `deadline` sur une tâche (ex. 2025-03-10).
- Le jour où la date est dépassée, et si l’item n’est pas marqué `done` :
  - l’item est considéré comme “en retard”.
- Plusieurs options :
  - l’utilisateur ajoute manuellement le tag `state/late`,
  - ou une règle (via Logique/Gestion) applique automatiquement ce tag, selon la politique choisie pour le board.
- Dans le board, l’état “en retard” peut :
  - être visible via un badge, une couleur, un filtre,
  - être utilisé comme critère pour les actions Interactions.

### 3.4. Identifier les items bloqués

- Une tâche T2 dépend d’une tâche T1 via le pack Relations.
- Si T1 est bloquée (tag `state/blocked` appliqué) :
  - T2 peut être marquée comme “bloquée par T1”,
  - visuellement, T2 indique son état “bloqué”,
  - l’utilisateur sait qu’il ne sert à rien d’essayer de l’avancer tant que T1 n’est pas résolue.

### 3.5. Marquer un échec

- Une tâche critique T a une échéance `deadline` dépassée depuis longtemps.
- L’équipe décide que l’objectif initial ne sera pas atteint :
  - un utilisateur autorisé applique le tag `state/failed` sur T,
  - éventuellement, il ajoute une échéance ou une note expliquant la décision.
- Résultat :
  - T reste dans l’historique comme “échouée / abandonnée” (et non simplement “non faite”),
  - des règles Logique ou des vues de reporting peuvent distinguer ces cas des simples retards.

### 3.6. Suivre des ressources matérielles (premiers pas)

- L’utilisateur crée un container “Stock de matériaux”.
- Il y crée des items “Eau”, “Bois”, “Métal” avec des quantités associées.
- Il peut :
  - ajuster les quantités manuellement (entrées / sorties),
  - plus tard, lier ces quantités à des actions Interactions (consommer 10 L d’eau, répartir du bois, etc.).
- V1 : la quantité est un entier **≥ 0** (pas de stock négatif), l’unité reste libre mais l’UI propose une liste suggérée pour éviter les agrégations incohérentes.
- Inventaire minimal :
  - la même ressource (ex. `resource/water`) peut exister sur plusieurs items,
  - une vue d’inventaire au niveau board (et filtrable par sous-arbre) agrège par `(type, unité)` et affiche les totaux.

## Contraintes & invariants métiers

### 4.1. Bornes et cohérence de la progression

- La progression est toujours dans [0 ; 10 000].
- 0 signifie “non commencé” ou “aucun progrès mesurable”.
- 10 000 signifie “100 % / totalement accompli”.
- Les changements de progression doivent être :
  - validés côté backend (pas de valeur hors bornes),
  - cohérents avec les états (un item `done` DOIT, dans la politique standard, avoir une progression
    effective égale à sa progression maximale).
- La progression “agrégée” d’un ensemble d’items (projet, phase, groupe) NE DOIT JAMAIS être calculée
  en sommant ou moyennant directement les progressions des enfants d’un container :
  - toute agrégation DOIT être définie à partir de relations explicites (ex. `rel/partOf`, `rel/depends-on`)
    et, le cas échéant, de règles Logique,
  - l’UI NE DOIT PAS afficher une progression de groupe si aucune relation/règle ne la justifie.

### 4.2. Interaction avec les états existants

- Les tags `todo/doing/done` existent déjà via le pack Organisation.
- Gestion vient les **augmenter**, non les remplacer :
  - `late`, `blocked`, `failed` sont des états complémentaires,
  - la combinaison d’états doit rester lisible (ex. un item peut être `todo + blocked`, ou `doing + late`).
- Les documents techniques préciseront comment gérer les incompatibilités ou exclusivités éventuelles.

### 4.3. Cohérence entre dates, états et progression

- Certaines combinaisons doivent être considérées comme incohérentes ou suspectes :
  - progression = 10 000 mais état ≠ `done`,
  - item marqué `late` sans échéance, etc.
- Gestion doit fournir des règles simples :
  - pour **refuser** les commandes qui rendent un état incohérent avec la progression (ex. `done` avec
    une progression non maximale),
  - et pour **signaler** les incohérences ou combinaisons “suspectes” (warnings, surlignages) sans les
    corriger silencieusement.
- En particulier, il n’existe plus de règle automatique “`done` ⇔ progression = max” appliquée en douce :
  - le noyau vérifie simplement les invariants (ex. `state/done` + progression non nulle ⇒ `effective = max`),
  - l’UI et/ou des règles explicites doivent envoyer des commandes cohérentes (par ex. bouton “Terminer”
    qui met d’abord la progression à `max`, puis applique `state/done`).

### 4.4. Extension progressive des ressources

- La prise en charge des ressources matérielles est optionnelle dans un premier temps.
- Lorsque le pack Gestion Ressources est activé, les types et unités sont **normalisés** via des
  catalogues MCC (`resource/*`, `unit/*`) afin d’éviter la dérive de labels libres et de garantir
  des agrégations cohérentes.

### 4.5. Contrats fonctionnels (résumé)

- États :
  - Les **états principaux** sont `state/todo`, `state/doing`, `state/done`, `state/failed`.
  - Pour un item donné, il peut y avoir **zéro ou un seul** état principal actif parmi ce set
    (jamais plus d’un à la fois).
  - Les flags `state/late` et `state/blocked` sont **complémentaires** :
    - ils ne peuvent apparaître qu’avec `state/todo` ou `state/doing`,
    - ils disparaissent dès qu’on passe à `state/done` ou `state/failed`.
  - Combinaisons explicites V1 (exemples) :
    - interdites : toute combinaison avec plus d’un état principal (`todo+doing`, `done+failed`, etc.),
      ainsi que `done+blocked`, `done+late`, `failed+blocked`, `failed+late`,
    - autorisées : `todo|doing` avec `late` et/ou `blocked` tant que la combinaison reste lisible.
    - Toute transition vers `state/done` ou `state/failed` supprime automatiquement `state/blocked` / `state/late`
      et refuse qu’ils restent présents.
- Dates & échéances :
  - Pour une catégorie donnée (`start`, `due`, `review`, `deadline`…), un item NE DOIT PAS avoir plus d’une échéance.
  - Un item marqué `state/late` DOIT avoir au moins une échéance pertinente (ex. `deadline`) qui a été dépassée.
  - À l’inverse, une échéance dépassée sans `done` rend l’item **éligible** à `state/late` mais ne l’applique pas
    obligatoirement : la mise à jour effective du tag `state/late` est gouvernée par des règles
    (Gestion/Logique) configurables par board.
- Progression :
  - `progressionEffective` DOIT être dans [0 ; `progressionMax`] et `progressionMax` dans [0 ; 10 000].
  - Dans la politique standard du pack Gestion, un item avec `progressionEffective = progressionMax`
    DOIT en pratique être en état “terminé” (tag `done` ou équivalent) ; si ce n’est pas le cas,
    la règle de cohérence **refuse** les combinaisons invalides et signale explicitement
    l’incohérence, sans corriger automatiquement les données. C’est à l’UI (ou à une séquence
    explicite de commandes) de mettre la progression à `max` puis d’appliquer `state/done`.
  - La progression agrégée d’un groupe NE DOIT PAS être déduite des seuls enfants structurels ; elle DOIT être
    définie par des relations et/ou des règles Logique explicites.
- Ressources :
  - Un item “ressource” DOIT préciser au minimum un type (`resource/*`) et une quantité (entier ≥ 0 en V1 ; stock négatif interdit).
  - Les unités restent configurables, mais les agrégations (totaux, stocks globaux…) NE DOIVENT combiner que
    des ressources de même type et de même unité :
    - pas de “total” mélangeant des litres et des kilogrammes,
    - si les types ou unités diffèrent, l’interface affiche les valeurs séparément ou n’agrège pas.

## Interactions avec les autres systèmes

### 5.1. Avec Relations

- Les relations “dépend de / bloque” interagissent fortement avec les états Gestion :
  - un blocage dans Relations peut se refléter par `state/blocked`,
  - un retard peut se propager dans une chaîne de dépendances (à définir via Logique).

### 5.2. Avec Interactions

- Les actions Interactions utilisent Gestion comme source de conditions et d’effets :
  - conditions “Avant” basées sur :
    - états (`late`, `blocked`, `failed`),
    - progression (>= X %),
    - dates/échéances (dépassées ou non),
    - quantités de ressources.
  - effets “Après” qui :
    - modifient des états,
    - ajustent la progression,
    - changent des dates,
    - consomment ou ajoutent des ressources.

### 5.3. Avec Logique

- Logique peut définir des règles globales sur :
  - la façon d’appliquer automatiquement `state/late`, `state/blocked`, `state/failed`,
  - la politique de progression (agrégation, normalisation),
  - la gestion des ressources.
- Gestion fournit les **briques de base** (champs, tags, structures), Logique orchestre des comportements avancés.

### 5.4. Avec Teams

- Certains états ou changements de progression peuvent être restreints :
  - seuls certains rôles (ex. “Contrôleur qualité”) peuvent marquer un item comme `done` ou `failed`,
  - seuls certains rôles peuvent modifier la progression au-delà d’un seuil.
- Teams décide :
  - qui peut modifier quoi,
  - Gestion définit ce qu’il est possible de modifier.
