# 09-activity – Vue fonctionnelle

Ce document décrit le pack Activity : journalisation et visualisation de l’**activité**
sur un board, par utilisateur et globalement.

---

## 1. Contexte / Problème

Skyboard dispose d’un moteur de commandes très structuré : chaque action de l’utilisateur
passe par une commande, ce qui rend possible :

- un historique détaillé,
- une traçabilité par utilisateur,
- une meilleure compréhension de l’évolution d’un board.

Mais aujourd’hui, cette richesse est peu exploitée côté utilisateur :

- pas de vue unifiée des actions,
- pas de journal par membre,
- pas de moyens simples de “remonter le fil” pour comprendre qui a fait quoi.

---

## 2. Objectifs fonctionnels

Activity doit fournir :

1. **Un journal d’activité global par board**
   - Liste chronologique des événements significatifs :
     - création / suppression / modification d’items,
     - changements d’état, d’échéances, de progression,
     - exécution d’actions Interactions,
     - modifications des règles Logique,
     - modifications de Teams (invitation, changement de rôle),
     - publications Community.

2. **Une vue d’activité par utilisateur**
   - Filtre “tout ce que tel membre a fait sur ce board”.
   - Permet :
     - de suivre la contribution de chacun,
     - de diagnostiquer des problèmes (erreurs, abus, malentendus).

3. **Une vue d’activité par item / container**
   - Historique des modifications concernant un item ou un sous-arbre :
     - qui l’a créé, modifié, déplacé, terminé, etc.

4. **Des filtres et regroupements**
   - Filtrer par type d’événement (structure, états, relations, interactions, logique, Teams, Community…).
   - Regrouper par jour, par utilisateur, par type.

---

## 3. Scénarios d’usage

### 3.1. Comprendre d’où vient un changement

- Un admin voit que la structure d’un projet a changé “dans la nuit”.
- Il ouvre l’activité du board filtrée sur la période :
  - voit quel utilisateur a déplacé / supprimé tel container,
  - peut lui parler avec un contexte clair.

### 3.2. Suivre la contribution d’un membre

- Un manager veut voir ce qu’un nouveau membre a fait sur un board.
- Il ouvre la vue “Activité de [Nom]” :
  - voit les tâches créées / terminées,
  - les actions déclenchées,
  - les modifications structurelles effectuées.

### 3.3. Auditer un item critique

- Un container “Roadmap” a des incohérences.
- L’admin ouvre l’historique de ce container :
  - voit la séquence des modifications,
  - peut identifier quand la structure a divergé.

---

## 4. Contraintes & invariants métiers

### 4.1. Respect de Teams

- L’activité visible pour un utilisateur ne doit montrer que :
  - les événements qui concernent des items qu’il a le droit de voir,
  - et masquer toute référence aux items invisibles (pas de fuite de contenu ni de compteur d’items masqués) ; si un item est partiellement visible, seules les parties autorisées sont montrées.
  - des détails en cohérence avec ses permissions (pas d’infos cachées révélées par le journal).
- Le moteur Activity conserve un journal interne complet, mais chaque vue (board, utilisateur, item)
  est une **projection filtrée** selon Teams :
  - deux utilisateurs peuvent voir des journaux différents pour un même board,
  - les “trous” dus à des événements sur des contenus invisibles ne sont pas signalés explicitement.

### 4.2. Lisibilité et synthèse

- L’activité doit rester lisible :
  - regroupements par période,
  - résumés, possibilité de “déplier” pour voir le détail.
  - l’UI PEUT regrouper plusieurs événements homogènes sur un même item et une fenêtre courte en un résumé, avec détail déroulable.

### 4.3. Performances

- L’historique peut être volumineux :
  - il faudra prévoir des limites, de la pagination, et peut-être des horizons (ex. 90 jours).

---

## 5. Interactions avec les autres systèmes

- **Avec Teams** :
  - Teams décide qui peut voir quelle partie de l’activité.
- **Avec Interactions & Logique** :
  - certaines entrées du journal concernent les actions/règles exécutées, utile pour le débogage.
- **Avec Community** :
  - certaines actions (publication, contributions) apparaissent aussi dans l’activité.

---

## 6. Décisions fonctionnelles détaillées

### 6.1. Taxonomie des événements

- Chaque entrée Activity appartient à une taxonomie stricte `kind.subkind` avec champs obligatoires par type (pas de texte libre) :
  - `structure.move` (fromParent, toParent, positions), `structure.rename`, `structure.delete/create`.
  - `state.change` (from, to), `deadline.set` (category, from, to), `progress.set` (from, to, max?).
  - `relation.created/deleted` (from, to, kind).
  - `interaction.run` (runId, status, actionsSuccess/Failed, reason).
  - `logic.rule` (ruleId, status, budgetUsed/Limit, reason).
  - `teams.roleChanged/invite/deny/grant`.
  - `community.publish/import/fork/unpublish` (sourceBoardId/publicBoardId, targetBoardId).
- Cette taxonomie alimente des messages templatisés côté UI (pas d’heuristique).

### 6.2. Projection Teams (lecture)

- Projection basée sur les droits **courants** du lecteur :
  - si toutes les `nodeRefs` sont invisibles → événement masqué entièrement (aucun stub, aucun compteur caché).
  - si mix visible/invisible → seules les références visibles sont montrées, sans mention du volume masqué.
  - `actorId` invisible/supprimé → rendu générique (“hidden”/“externe”), sans fuite d’ID.
  - payload redigé : suppression des champs sensibles (contenu, tags non visibles).
- Deux utilisateurs peuvent voir des journaux différents pour un même board ; divergence assumée.

### 6.3. Lisibilité & anti-bruit

- Regroupements par jour/utilisateur/type + coalescing lecture sur fenêtre courte (ex. 60 s) pour les mises à jour répétées (`progress.set`, `state.change`).
- Résumé “dépliable” pour voir le détail fusionné.
- Pagination obligatoire ; horizon par défaut 90 jours configurable par board (requête au-delà → code explicite).

### 6.4. Traçabilité des runs Interactions/Logique

- Chaque run génère deux événements liés par `runId` :
  - `run.start` (actor, contexte).
  - `run.end` (status success/partial/failed, actionsSuccess, actionsFailed, budgetUsed/Limit, reason ou code de rollback).
- Utile pour répondre “pourquoi cette action/règle ne s’est pas exécutée ?”.

### 6.5. Community / Library

- Les événements cross-board incluent toujours `sourceBoardId`/`publicBoardId` et `targetBoardId` (fork/import).
- Les publications/imports/forks sont journalisés côté source et côté cible (quand le board existe), toujours filtrés par Teams.

### 6.6. Exports / anonymisation

- Export audit complet (JSONL) avec option `anonymizeActors=true` (pseudonymes stables par board).
- Le journal persiste complet ; la projection et l’anonymisation d’export couvrent le besoin de confidentialité.
