# 05-logic – Vue fonctionnelle

Ce document décrit le pack Logique : extension des types et écriture de **règles custom** par l’utilisateur avancé.

Logique fournit un **langage de règles global** au-dessus des packs existants (Gestion, Relations, Interactions, Teams, Community).

---

## Contexte / Problème

Les packs prédéfinis (Gestion, Relations, Interactions…) couvrent des scénarios courants via :

- des actions localisées (Interactions, centrées sur un item porteur),
- des comportements standard (états, échéances, relations, droits…).

Mais certains utilisateurs auront des besoins qui dépassent ces scénarios :

- définir des politiques globales sur tout un board (ou plusieurs),
- déclencher des comportements sur des événements qui ne sont pas exposés par Interactions,
- introduire de nouveaux types d’états, d’échéances, de relations, avec leurs propres règles.

Le pack Logique vient répondre à ce besoin en offrant :

- un **moteur de règles configurable**,
- un endroit unique (panneau de configuration globale) où écrire des règles sur mesure.

---

## Objectifs fonctionnels

Logique doit permettre à un utilisateur avancé de :

1. **Définir de nouveaux types et catégories**
   - États custom (ex. `state/on-hold`, `state/archived`…).
   - Types d’échéances supplémentaires (ex. `review`, `milestone`…).
   - Types de relations custom (`rel/supports`, `rel/is-alternative-of`, etc.).

2. **Définir des règles globales basées sur des événements variés**
   - Événements locaux (similaires à Interactions) mais **sans item porteur imposé** :
     - ex. “Quand n’importe quel item de type T passe à l’état `en retard`…”.
   - Événements temporels :
     - ex. “Tous les jours à 02h, vérifier tel invariant”.
   - Événements de structure / Relations :
     - ex. “Quand une relation `rel/depends-on` est créée/supprimée…”.

3. **Introduire de nouveaux types d’événements utilisables par Interactions**
   - Ajouter des événements supplémentaires pour les actions du pack Interactions, toujours centrés sur l’item porteur :
     - ex. “Quand la progression de l’item porteur dépasse un certain seuil”,
     - ex. “Quand la quantité d’un champ numérique baisse de X”,
     - ex. “Quand l’item porteur passe à l’état `en retard` ou `bloqué`”.
   - Ces événements deviennent des options dans la configuration d’une action Interactions (en plus de l’événement par défaut “porteur terminé”).

4. **Exprimer des conditions complexes sur l’état du board**
   - Combiner plusieurs critères :
     - tags, états, progression, dates, relations, appartenance à un container, etc.
   - Filtrer des ensembles d’items :
     - ex. “tous les items en retard dans ce workspace, sauf ceux de type X”.

5. **Définir des effets globaux**
   - Appliquer des tags / états à des ensembles d’items.
   - Créer / supprimer / modifier des items en réponse à des patterns.
   - Modifier des relations (ex. reconfigurer des dépendances en cascade).

6. **Gérer ces règles dans un espace dédié**
   - Un panneau de configuration global (par board ou global au compte) :
     - liste des règles existantes,
     - activation/désactivation,
     - édition avancée,
     - explication et documentation des règles.

---

## Scénarios d’usage

### 3.1. Politique globale sur les retards

- L’utilisateur définit :
  - Événement : “Tous les jours à 05h”.
  - Condition : “Items avec échéance dépassée” et “non terminés”.
  - Effet : appliquer le tag `state/late`.
- Résultat :
  - même sans action locale Interactions, le board applique une politique globale de retard.

### 3.2. Règle sur les relations

- L’utilisateur définit :
  - Événement : “Quand une relation `rel/depends-on` est créée”.
  - Condition : “Si cela introduit un cycle dans le graphe”.
  - Effet : rejeter la relation, ou appliquer un tag `state/invalid-dependency` sur l’item concerné.

### 3.3. Extension d’un type d’état

- L’utilisateur ajoute un état `state/on-hold`.
- Il définit :
  - Événement : “Quand un item passe en `state/on-hold`”.
  - Effets :
    - mettre tous ses descendants (containers/leafs) en `state/on-hold`,
    - bloquer certains types d’actions ou de transitions.

### 3.4. Couche d’orchestration au-dessus des actions Interactions

- Une règle Logique peut, par exemple :
  - activer/désactiver certaines actions Interactions selon des contextes globaux,
  - changer des paramètres par défaut (ex. quels types d’items peuvent être ciblés).

---

## Contraintes & invariants métiers

### 4.1. Compréhensibilité

- Même si Logique s’adresse à des utilisateurs avancés, les règles doivent rester lisibles :
  - phrases proches du métier,
  - affichage clair des événements, conditions, effets.

### 4.2. Cohérence avec les packs existants

- Logique **n’a pas le droit de casser** :
  - les invariants structuraux (container/leaf),
  - les invariants de Relations (pas de cycles),
  - les règles de base de Gestion (cohérence des états/échéances/progression).
- Logique peut les étendre, pas les invalider.
- Les règles déposées par les packs (système, Gestion, Relations, Interactions, etc.) :
  - ne sont pas supprimées, mais **toggleables** (activables/désactivables) dans l’interface de Logique,
  - peuvent être **supplantées** par des règles custom qui prennent le relais sur un même comportement,
    dans le respect des invariants ci-dessus.

### 4.3. Garde-fous

- Le système doit empêcher :
  - les boucles infinies entre règles,
  - les règles trop coûteuses (sur des boards énormes) sans avertissement,
  - les configurations manifestement dangereuses (ex. suppression massive sans confirmation).
- Un **budget d’exécution** doit être appliqué aux règles :
  - nombre maximal d’itérations / d’actions dérivées par déclenchement,
  - si le budget est dépassé, l’évaluation s’arrête et une erreur claire est remontée à l’utilisateur.

---

## Interactions avec les autres systèmes

### 5.1. Avec Interactions

- Interactions :
  - actions **locales**, centrées sur un item porteur, avec un événement “porteur terminé” en V1.
- Logique :
  - règles **globales**, pas limitées à un item porteur,
  - peut définir des événements plus généraux pour ses propres règles,
  - et déclarer de **nouveaux types d’événements** utilisables comme triggers pour les actions Interactions (toujours centrés sur l’item porteur).

Logique étend donc la puissance d’Interactions sans en changer la nature :
- Interactions reste l’interface guidée,
- Logique est la “couche experte” qui manipule le même moteur sous-jacent.

### 5.2. Avec Gestion

- Gestion définit :
  - les types d’états, d’échéances, de progression, de ressources.
- Logique permet :
  - de créer des comportements personnalisés sur ces états/échéances (ex. politiques de retard),
  - de composer des conditions plus riches (progression + relations + dates…).

### 5.3. Avec Relations

- Relations fournit la structure de dépendances.
- Logique peut :
  - surveiller les changements de relations,
  - empêcher certaines configurations (cycles, patterns interdits),
  - dériver des états à partir du graphe de relations.

### 5.4. Avec Teams

- Logique ne doit pas contourner les permissions :
  - les règles sont évaluées **en respectant** les droits existants.
- Certaines règles pourront être réservées à des rôles particuliers (admin, mainteneur).
- Logique ne définit pas les permissions (qui a le droit de faire quoi) :
  - cette responsabilité revient au pack Teams et à ses “capabilities”,
  - Logique peut **lire** certaines informations de Teams comme conditions (rôle, compétence, etc.),
    mais ne peut pas attribuer de droits ni modifier la base de permissions.
- Toute modification effective des droits (ajout/retrait de permissions, changement de rôle, etc.)
  DOIT passer par les mécanismes Teams (commandes et règles dédiées) ; au mieux, une règle Logique peut
  suggérer ou préparer une telle modification, jamais l’appliquer directement.
- Hiérarchie d’override : invariants noyau > règles pack non overridables > règles pack overridables > règles Logique custom. Une règle custom ne peut supplanter qu’une règle pack marquée overridable ; en cas de conflit d’effets, on échoue explicitement plutôt que de faire du “last-wins” implicite.

### 5.5. Avec Community

- Les règles Logique d’un board publié :
  - peuvent être exposées comme partie de la “logique interne” du template,
  - peuvent être importées / adaptées par d’autres utilisateurs.

La manière dont ces règles sont partagées (copiées, anonymisées, partiellement masquées)
sera à préciser dans la phase Community.
