# 06-teams – Vue fonctionnelle

Ce document décrit le pack Teams : gestion des droits, des scopes, des hiérarchies d’autorisations
et de l’expérience de collaboration sur un même board.

On se concentre ici sur **ce que l’utilisateur peut faire / voir** en présence de plusieurs personnes,
pas encore sur la mécanique technique.

---

## 1. Contexte / Problème

Sans Teams, un board appartient de facto à un seul utilisateur :

- soit tout est privé,
- soit on partage “tout ou rien” via des mécaniques externes (export, duplication…),
- il est difficile de laisser quelqu’un intervenir **sans surveiller** en permanence.

Les besoins exprimés sont :

- inviter des collaborateurs sur un board sans qu’ils puissent “casser” la structure,
- donner à certains des droits limités (ex. modifier le contenu mais pas la structure),
- lier certains droits à des **affectations** (ex. “tu peux modifier les items auxquels tu es assigné”),
- établir une **hiérarchie claire de droits** pour éviter les conflits et surprises.

L’idée maîtresse :

- permettre à un administrateur de définir des règles de droits suffisamment fines pour :
  - encourager l’initiative des collaborateurs,
  - tout en rendant techniquement impossible qu’ils détruisent ou déforment le board.

---

## 2. Objectifs fonctionnels

### 2.1. Rôles et droits de base

Le système doit proposer une base de rôles explicites, par exemple :

- **Propriétaire / Admin du board**
  - a tous les droits sur le board : structure, contenu, règles, partage, Teams lui-même.
- **Mainteneur**
  - peut modifier la plupart des éléments (structure, contenu, actions, logique locale),
  - ne peut pas forcément changer les paramètres sensibles (règles globales, licences, suppression du board).
- **Contributeur**
  - peut créer / modifier / terminer des items dans un périmètre donné,
  - ne peut pas changer la structure globale (containers critiques, actions, logique, Teams).
- **Lecteur**
  - peut consulter, filtrer, mais pas modifier.

Les rôles peuvent être **affinés** par des permissions plus granulaires (voir ci-dessous),
mais servent de base “compréhensible” pour l’utilisateur.

### 2.2. Scopes de permissions

Les droits ne sont pas seulement par “type d’action” mais aussi par **périmètre** :

- scope **board entier**,
- scope **sous-arbre** (un container et tous ses descendants),
- scope **item individuel**.

Un même utilisateur peut cumuler plusieurs scopes :

- admin sur tout le board,
- mais contributeur seulement sur un sous-arbre,
- ou lecteur partout + contributeur sur certains items.

### 2.3. Types de permissions

Les permissions doivent être suffisamment expressives pour couvrir :

- **Visibilité**
  - voir ou non un item (ou un container et son sous-arbre),
  - voir ou non certains champs sensibles (ex. certaines dates, ressources, notes privées).
- **Édition de contenu**
  - modifier le titre, la description, les tags non système,
  - commenter, ajouter des pièces jointes.
- **Édition structurelle**
  - créer / supprimer des items,
  - déplacer des items (DnD, déplacement cross-container),
  - créer / supprimer des containers.
- **État & gestion**
  - appliquer des tags d’état (todo/doing/done, late, blocked, failed…),
  - modifier la progression,
  - gérer les échéances (deadlines).
- **Relations / Interactions / Logique**
  - créer / supprimer des relations,
  - créer / modifier / exécuter des actions (Interactions),
  - créer / modifier des règles globales (Logique).
- **Partage & configuration**
  - inviter / retirer des membres (Teams),
  - publier dans Community,
  - gérer les paramètres globaux du board.

Ces permissions sont **combinaison de base** des rôles :

- un rôle standard est une pré-configuration,
- mais un admin peut ajuster les permissions pour des cas particuliers.

### 2.4. Droits liés à l’affectation

Un mécanisme important :

- l’**affectation** d’un utilisateur à un item (ou container) se matérialise par un **tag système d’assignation**
  (par exemple `assigned/mathieu`), appliqué explicitement sur l’item ou sur un container.
- ces tags d’assignation, en eux-mêmes, ne donnent **aucun droit automatique** :
  - ils sont des signaux métier (“qui est responsable de quoi ?”),
  - c’est Teams (ou des règles Logique) qui décide ce que “être assigné” permet concrètement.
- Teams fournit des **règles/préréglages** courants exploitant l’affectation, par exemple :
  - “Tout membre peut modifier les items dont il est assigné responsable”.
  - “Un external peut voir tout le board, mais ne modifier que les items où il est affecté”.

Exemples :

- “Tout membre peut modifier les items dont il est **assigné responsable**.”
- “Un external peut voir tout le board, mais ne modifier que les items où il est **affecté**.”

L’affectation devient donc un **signal métier** exploité par Teams pour moduler les droits.

Les équipes avancées peuvent, via le pack Logique, définir des règles plus sophistiquées autour
de ces tags d’assignation (par exemple limiter le nombre d’affectations simultanées, définir des
cas particuliers par type d’item, etc.).

### 2.5. Hiérarchie et résolution des droits

Pour éviter les surprises, il faut une hiérarchie claire :

- les droits peuvent venir :
  - du rôle global sur le board,
  - de rôles / permissions spécifiques sur un scope (container, item),
  - de l’affectation,
  - de règles Logique éventuelles (mais toujours dans un cadre autorisé).

Principes :

- **Principe de moindre privilège** :
  - par défaut, un utilisateur n’a aucun droit sur un board où il n’est pas invité.
- **Priorité des interdictions explicites** :
  - un “refus explicite” sur un scope donné doit primer sur un “grant” plus large,
    sauf pour le propriétaire/admin.
- **Héritage lisible** :
  - un droit accordé sur un container s’applique à son sous-arbre,
  - des exceptions peuvent être définies mais sont visibles (UI indiquant d’où vient le droit).

### 2.6. Lots de droits (“capabilities”) et rôles personnalisés

- Pour éviter de gérer les permissions une par une, Teams introduit la notion de **lot de droits** (“capability”) :
  - une capability regroupe un ensemble cohérent de permissions (ex. “lecture sur tous les items tagués `informatique`”, “modération sur les items de type forum”).
- Les **rôles** sont construits en combinant plusieurs capabilities :
  - les rôles de base (Admin, Mainteneur, Contributeur, Lecteur) sont des combinaisons prédéfinies,
  - l’admin peut créer des rôles personnalisés (“Modérateur forum”, “Contrôleur qualité”) en choisissant les capabilities qui les composent.
- Les capabilities peuvent être regroupées par **familles** (ex. “Compétences métier” : mécanique, informatique, etc.) pour garder l’interface lisible.
- L’admin attribue des rôles aux utilisateurs ; il n’a pas besoin de gérer directement chaque permission fine :
  - changer un rôle met à jour immédiatement les droits associés à toutes ses capabilities.

---

## 3. Scénarios d’usage

### 3.1. Inviter un collaborateur en lecture seule

1. L’admin du board ouvre un panneau “Équipe / Partage”.
2. Il ajoute un utilisateur (par email ou via un sélecteur interne).
3. Il lui attribue le rôle “Lecteur”.
4. Le collaborateur voit :
   - le board dans sa liste de boards,
   - tout le contenu pour lequel il a la visibilité,
   - mais ne peut effectuer aucune action de modification.

### 3.2. Donner des droits de contribution limités à un sous-arbre

1. L’admin a un container “Projet X” dans un board général.
2. Il invite un freelance et lui donne :
   - rôle global “Lecteur”,
   - rôle “Contributeur” sur le container “Projet X” (scope sous-arbre).
3. Résultat :
   - le freelance peut parcourir tout le board en lecture,
   - mais ne peut créer / modifier / supprimer que des items dans “Projet X”.

### 3.3. Droits conditionnels par affectation

1. L’admin veut que chaque membre puisse gérer **ses propres tâches**.
2. Il configure Teams pour le board ainsi :
   - règle : “Tout membre peut modifier les items dont il est affecté responsable”.
3. Lorsqu’un user A est assigné à une tâche T :
   - il peut modifier le contenu, les états, les dates de T,
   - mais pas nécessairement : déplacer T dans un autre container, changer des actions ou règles associées.

### 3.4. Protéger la structure tout en laissant le contenu libre

1. L’admin a défini une structure complexe (containers, relations, actions).
2. Il veut que l’équipe puisse modifier librement le contenu sans toucher à la structure.
3. Il donne au rôle “Contributeur” :
   - droits d’édition de contenu (titre, description, progression, dates…),
   - droits d’état (todo/doing/done, late, etc.),
   - mais **pas** :
     - création/suppression de containers,
     - déplacement d’items critiques,
     - modifications des actions Interactions ou des règles Logique.

Les membres peuvent “travailler dans les cases” sans casser le cadre.

### 3.5. Utilisation combinée avec Interactions

1. Un item “Action” existe (“Quand cette tâche est terminée, créer des items de suivi chez X, Y, Z”).
2. Quand un utilisateur sans droits suffisants tente de terminer l’item :
   - soit l’action est refusée (transition d’état interdite),
   - soit l’action est marquée “non exécutable” pour lui.
3. L’interface explique clairement :
   - qu’il n’a pas les droits pour déclencher l’action,
   - ou que certaines parties de l’action ne pourront pas s’exécuter.

### 3.6. Configurer rôles, capabilities et membres via un onglet Teams

1. L’admin ouvre le **panneau de configuration globale** du board.
2. Il va dans l’onglet “Teams” (ou “Équipe & droits”), qui propose au minimum :
   - une section “Membres” :
     - liste des utilisateurs invités sur le board,
     - rôle actuel, scopes spécifiques, statut (actif, invité, etc.).
   - une section “Rôles & capabilities” :
     - liste des rôles disponibles (standards + personnalisés),
     - pour chaque rôle, aperçu des capabilities qui le composent,
     - possibilité de créer un nouveau rôle à partir de lots de droits.
3. En option avancée, une section “Règles de permissions” permet de définir des comportements plus fins :
   - ex. règles basées sur l’affectation ou sur certains tags d’items.
4. L’interface reste hiérarchisée :
   - la plupart des admins utilisent les rôles standards et quelques variantes simples,
   - les capabilities et règles avancées sont accessibles pour ceux qui ont besoin de granularité maximale.

---

## 4. Contraintes & invariants métiers

### 4.1. Principe de moindre privilège

- Par défaut, un utilisateur ne voit et ne modifie que ce qui lui est explicitement permis.
- Les droits **ne sont jamais inférés** à partir de comportements implicites dangereux.

### 4.2. Lisibilité des permissions

- Un utilisateur doit pouvoir comprendre :
  - pourquoi il peut ou ne peut pas faire une action,
  - d’où provient un droit (rôle global, scope, affectation).
- L’admin doit disposer d’une vue synthétique :
  - des membres,
  - des rôles,
  - des scopes particuliers définis.

### 4.3. Traçabilité & historique

- Toute action effectuée sur un board (commande) doit pouvoir être :
  - rattachée à un utilisateur (ou au système),
  - visible dans un **journal d’activité**.
- Deux vues principales sont nécessaires :
  - un **historique global du board** (chronologie des opérations),
  - un **historique par utilisateur** (tout ce que tel membre a fait sur ce board).
- Ces vues permettent :
  - de comprendre qui a modifié quoi et quand,
  - de mieux coordonner le travail de l’équipe,
  - de diagnostiquer des problèmes (erreurs, abus, malentendus).

Un pack spécifique “Activité” détaillera la forme précise de ces journaux, mais Teams pose
fonctionnellement l’exigence que les actions des membres soient traçables.

### 4.4. Cohérence avec les autres packs

- Aucune fonctionnalité des packs (Interactions, Logique, Relations, Gestion, Community) ne doit
  permettre de contourner Teams :
  - toute commande (création, suppression, modification, exécution d’action) est soumise à la vérification des droits.
- Les packs peuvent proposer des options d’UI différentes selon le rôle (ex. certaines tabs désactivées) :
  - mais la vraie barrière reste dans Teams (contrôle des commandes).
- Teams est l’unique source de vérité des permissions persistées :
  - aucun autre pack ne doit enregistrer ses propres règles de droits parallèles,
  - s’il y a besoin de nouveaux types de droits, ils sont ajoutés dans Teams (capabilities, rôles), pas ailleurs.

### 4.5. Priorité et conflits de règles

- En cas de conflits :
  - le refus explicite sur un scope précis prime sur un grant plus large,
  - sauf pour le propriétaire/admin (qui reste souverain).
- Les règles Logique ne peuvent pas :
  - accorder des droits qu’un utilisateur n’a pas,
  - exécuter des actions au nom d’un utilisateur sans respecter ses permissions.

---

## 5. Interactions avec les autres systèmes

### 5.1. Avec Foundations (adressage, sélection)

- Teams utilise les adresses `{ boardId, nodeId }` comme base :
  - les permissions s’expriment sur des items ou des scopes définis par des containers.
- Le moteur de sélection universelle peut être filtré par Teams :
  - un utilisateur ne peut pas sélectionner comme cible un item qu’il n’a pas le droit de voir ou de modifier.

### 5.2. Avec Interactions

- Lorsqu’une action Interactions est déclenchée :
  - l’exécution de chaque effet est contrôlée vis-à-vis des droits de l’utilisateur qui déclenche,
  - certains effets peuvent être interdits si la permission manque.
- L’UI Interactions peut :
  - masquer certaines options de configuration aux rôles non autorisés,
  - empêcher l’exécution d’une action si l’utilisateur ne remplit pas les critères de permissions.

### 5.3. Avec Logique

- Les règles Logique sont évaluées **en respectant Teams** :
  - une règle ne peut pas simuler une commande que l’utilisateur n’aurait pas le droit d’émettre.
- Logique peut néanmoins :
  - proposer des règles qui modulent certains comportements selon le rôle (ex. notifications, états par défaut),
  - mais pas changer la base de permissions sans passer par Teams.

### 5.4. Avec Gestion

- Certains états ou transitions peuvent être réservés à certains rôles :
  - ex. seuls les mainteneurs peuvent marquer un item comme “validé” ou “archivé”.
- Les dates/échéances peuvent déterminer qui doit être informé, mais pas qui a le droit d’agir
  (c’est Teams qui tranche).

### 5.5. Avec Community

- Lorsqu’un board (ou un container) est rendu public :
  - Teams détermine qui peut le publier,
  - Community détermine qui peut ensuite voir / forker / contribuer.
- Les contributions externes (depuis Community) sont soumises à des permissions spécifiques :
  - ex. contributions proposées, à valider par un membre interne avec les droits suffisants.

---

Ce document fixe les attentes fonctionnelles pour le pack Teams : rôles, scopes, droits liés
à l’affectation, résolution de conflits et articulation avec les autres packs.  
Les spécifications techniques détailleront ensuite comment ces règles sont encodées
et vérifiées dans le pipeline de commandes. 
