# 07-community – Vue fonctionnelle

> ⚠️ **Périmètre V1**  
> Le pack Community est pensé comme une **phase ultérieure** : il n’est pas dans le périmètre de la
> première version mise en production. Ce document sert de vision fonctionnelle à moyen terme, à
> valider lorsque le noyau (Fondations, Gestion, Relations, Interactions, Logic, Teams) sera stabilisé.

Ce document décrit le pack Community : le **hub public** où certains contenus
de Skyboard (boards, containers, modèles) peuvent être publiés, découverts et utilisés
par d’autres utilisateurs.

Community ne remplace pas Teams : il complète la collaboration privée par une couche
de partage et de découverte publique/semipublique.

---

## 1. Contexte / Problème

Aujourd’hui, un board est essentiellement :

- privé à un utilisateur (ou à son équipe via Teams),
- partageable seulement via duplication/export manuel.

Mais certains scénarios demandent plus :

- publier des projets pour trouver des contributeurs,
- exposer des besoins (ressources, compétences) pour attirer de l’aide,
- partager des modèles (structures, actions, règles) comme “templates”,
- découvrir ce que font les autres, s’en inspirer, forker des bases existantes.

Le pack Community fournit un **hub** :

- page d’accueil / vue globale où sont listés :
  - des boards ou containers rendus publics,
  - des modèles de Library publiés,
  - des projets en recherche de contributions.

---

## 2. Objectifs fonctionnels

### 2.1. Publication contrôlée

- Permettre au propriétaire/admin d’un board de :
  - **publier** un board entier,
  - ou publier seulement certains containers (sous-arbres) comme “vitrines”,
  - ou publier seulement des modèles (via Library).
- La publication doit être :
  - **explicite** (acte volontaire, pas implicite),
  - **réversible** (possibilité de retirer un contenu publié),
  - **configurable** (niveau de visibilité : public, limité à un cercle, etc. – à préciser plus tard),
  - **expurgée** des données sensibles (Teams, assigned, données internes) ; les actions/règles publicables sont incluses mais arrivent inactives chez l’importeur.

### 2.2. Visibilité & découverte

- Fournir un hub où les contenus publics sont :
  - listés, filtrables, triables (par thème, popularité, date, géographie si applicable),
  - consultables via une fiche récapitulative (titre, description, tags, auteur, etc.).
- Permettre à un utilisateur de :
  - parcourir les contenus,
  - rechercher des projets / modèles pertinents (mots-clés, catégories, besoins).

### 2.3. Import & fork

- Depuis un contenu Community, un utilisateur doit pouvoir :
  - **importer** un modèle dans l’un de ses boards (via Library),
  - **forker** un board ou un container publié :
    - créer un nouveau board dans son espace, initialisé avec une copie du contenu,
    - ou insérer un container publié dans un de ses boards.
- L’import/fork ne doit pas :
  - affecter le contenu d’origine,
  - transférer des informations confidentielles non voulues,
  - activer automatiquement des actions/règles importées : elles arrivent inactives, scheduler/logique désactivés par défaut tant qu’ils ne sont pas explicitement activés.

### 2.4. Exposer les besoins & contributions possibles

- Un projet publié peut exposer des **besoins** :
  - besoins en compétences (ex. “dev backend”, “graphiste”),
  - besoins en ressources (ex. “manque de X unités de ressource Y”),
  - besoins en tâches spécifiques (issues / todo publiques).
- Ces besoins peuvent être dérivés :
  - de la structure même du board (tags, états, ressources, actions),
  - ou renseignés manuellement (description libre).
- Un utilisateur externe peut :
  - proposer une contribution (commentaires, tâches, ressources, etc.),
  - soumettre une “merge request” fonctionnelle (mettant en jeu Interactions/Logique),
  - mais la validation reste entre les mains de l’équipe du board (via Teams).

---

## 3. Scénarios d’usage

### 3.1. Publier un board pour attirer des contributeurs

- Un utilisateur admin a un board “Projet open source”.
- Il décide de le publier sur le hub Community :
  - il choisit ce qui est exposé (board complet ou certains containers),
  - il ajoute une description, des tags, éventuellement des besoins spécifiques.
- Sur la page Community :
  - le board apparaît avec sa fiche (titre, description, tags, auteur),
  - les visiteurs peuvent le consulter et décider de contribuer ou de forker.

### 3.2. Partager un modèle Library

- Un utilisateur a construit un modèle “Template de sprint agile” dans Library.
- Il choisit de le rendre public :
  - le modèle apparaît dans la section “Templates” du hub Community,
  - d’autres utilisateurs peuvent l’importer dans leurs boards.
- Le modèle peut être mis à jour :
  - les nouvelles versions peuvent être publiées (conservant éventuellement l’historique),
  - les utilisateurs importent la version qui les intéresse.

### 3.3. Publier un container comme “microsite” de projet

- Un board contient plusieurs projets ; l’utilisateur veut publier seulement un projet précis.
- Il sélectionne un container “Projet X” et le publie :
  - Community crée une entrée “Projet X” avec :
    - une vue filtrée du board sur ce container et ses enfants,
    - des infos de contexte (tags, échéances, progression globale).
- Les visiteurs voient “Projet X” comme une entité autonome, sans voir le reste du board privé.

### 3.4. Découvrir des projets proches géographiquement

- Un utilisateur veut trouver des projets près de chez lui.
- Community propose un filtre / tri “proximité géographique” (si l’info existe) :
  - les projets sont listés par distance / pays / région,
  - l’utilisateur peut filtrer par thème + localisation.

### 3.5. Proposer une contribution externe

- Un utilisateur externe voit un projet “Recherche de volontaires pour événement Y”.
- Il propose une contribution :
  - par exemple, en remplissant un formulaire associé,
  - ou en proposant un patch de tâches / ressources / actions (selon ce que Community supportera).
- L’équipe du board reçoit une notification :
  - peut accepter / rejeter / intégrer partiellement la contribution,
  - la décision reste contrôlée par Teams (droits internes au board).

---

## 4. Contraintes & invariants métiers

### 4.1. Respect de Teams & confidentialité

- La publication ne doit jamais contourner Teams :
  - seuls les rôles autorisés peuvent publier un board/container/modèle.
- Ce qui est visible dans Community :
  - ne doit montrer que ce que le propriétaire accepte explicitement de rendre public,
  - ne doit pas exposer des informations privées (notes internes, commentaires sensibles, etc.).
  - Le fait de publier un contenu dans Community n’accorde AUCUN droit supplémentaire sur le board source :
  - consulter ou forker un contenu publié ne donne pas d’accès en écriture au board original,
  - toute contribution externe passe par des mécanismes dédiés, vérifiés par Teams.
- Nettoyage de publication :
  - les tags d’affectation `assigned/*` et autres données sensibles sont supprimés ou anonymisés avant publication,
  - la logique interne (Interactions/Logique) n’est pas publiée par défaut ; inclusion optionnelle explicite si le propriétaire le souhaite.
  - les notes/commentaires marqués comme internes/ne devant pas sortir du board sont exclus par défaut ; seuls les contenus explicitement marqués comme publiables peuvent être embarqués.

### 4.2. Séparation original / fork

- Un fork / import Community crée **une nouvelle instance** :
  - rien de ce que l’utilisateur fait sur sa copie ne modifie le projet d’origine,
  - sauf via des mécanismes explicites de contribution / merge.
- Il n’existe pas de synchronisation implicite entre original et forks : toute propagation éventuelle
  de changements fera l’objet d’une feature distincte, avec ses propres règles.

### 4.3. Modération & qualité

- Le hub Community doit pouvoir :
  - filtrer / modérer des contenus inappropriés,
  - gérer des signalements,
  - éventuellement mettre en avant des contenus recommandés / de qualité.

### 4.4. Performance & scalabilité

- Le hub peut contenir de nombreux projets / modèles :
  - il faudra prévoir pagination, recherche, filtres,
  - sans impacter les performances du noyau des boards privés.

---

## 5. Interactions avec les autres systèmes

### 5.1. Avec Teams

- Teams définit :
  - qui peut publier un board, un container ou un modèle,
  - qui peut accepter / rejeter des contributions externes.
- Les droits Community s’appuient sur les rôles Teams existants.

### 5.2. Avec Library

- Library fournit les modèles, Community fournit le canal de partage :
  - un modèle Library peut être “publié” dans Community,
  - un autre utilisateur peut importer ce modèle dans son espace.

### 5.3. Avec Interactions & Logique

- Certains besoins d’un projet peuvent être dérivés :
  - d’actions Interactions non satisfaites (manque de ressources, conditions non remplies),
  - de règles Logique qui expriment des “gaps” ou des objectifs non atteints.
- Community peut présenter ces besoins sous une forme synthétique pour les visiteurs.

### 5.4. Avec Gestion & Relations

- Les informations de Gestion (états, retards, progression) et de Relations (dépendances) peuvent :
  - alimenter les indicateurs visibles sur un projet Community,
  - aider à comprendre l’avancement global et les parties bloquées.

### 5.5. Avec Activity

- Les actions liées à Community (publication, fork, contributions) apparaissent dans l’Activity :
  - côté board (ce qui a été publié, quelles contributions intégrées),
  - éventuellement côté utilisateur (ce qu’il a publié ou contribué dans Community).
