# 08-library – Spécifications techniques

> ⚠️ **Périmètre V1**  
> Le pack Library n’est **pas** dans le périmètre de la première version mise en production.  
> Ce document décrit une phase ultérieure (post‑V1) et sert de base de design ; aucune implémentation
> n’est requise tant que Fondations, Gestion, Relations, Interactions, Logic et le cœur de Teams
> ne sont pas stabilisés.

## Concepts techniques clés

- Modèles = snapshots partiels (item, sous-arbre, action/config) sérialisés avec métadonnées (auteur, visibilité, dates relatives).
- Actions/règles incluses sont importées **inactives** par défaut ; activation explicite par le consommateur.
- Dates : stockées en relatif par défaut (offsets), conversion à l’insertion.
- Nettoyage publication : suppression/anonymisation `assigned/*`, données sensibles ; aligné sur Community.

## Points d’intégration

- UI : palette de modèles avec options (dates relatives, activer actions/règles ou non).
- Commandes : `CreateFromTemplate` (ou équivalent) qui remappe `nodeId`, applique dates relatives, insère dans un container cible.
- Teams : contrôle de visibilité/usage des modèles (privé/équipe/public).
- Community : export/import avec même pipeline d’expurgation qu’en publication Community.

## Structures de données

- Schéma modèle (exemple) :

  ```json
  {
    "id": "template-uuid",
    "visibility": "private|team|public",
    "kind": "item|subtree|action|config",
    "snapshot": { ... },
    "actions": [ ... inactives ... ],
    "rules": [ ... inactives ... ],
    "metadata": { "title": "...", "description": "...", "tags": ["..."], "createdAt": 1736463600 }
  }
  ```

- `snapshot` utilise des `nodeId` propres au modèle ; ils sont régénérés à l’insertion.
- Dates relatives : stockées sous forme d’offsets (en jours/secondes) à appliquer lors de l’insertion.

## Flux types

- Enregistrement : sélection d’un item/sous-arbre → sérialisation + métadonnées + options (inclure actions/règles, dates relatives).
- Insertion : choix du container cible → remap `nodeId` + application des offsets de dates → actions/règles insérées **désactivées** par défaut → log Activity.
- Publication : passage par le pipeline Community (expurgation, génération d’un `publicId`).
- Import depuis Community : instanciation identique à l’insertion locale, avec actions/règles désactivées tant que l’admin ne les active pas.

## Questions ouvertes / risques

- Gestion de la compatibilité des modèles avec des packs privés/licenciés.
- Taille des modèles complexes (sous-arbres profonds).
- Évolution du format si on introduit un “modèle lié” (non prévu en V1).
