# ZZ-global-synthesis – Synthèse globale (fonctionnelle)

Ce document sera rédigé en **deuxième phase**, une fois que tous les autres dossiers auront une première version stable.
Il servira de vue d’ensemble fonctionnelle consolidée.

## Principes globaux retenus

- Identité : adresse canonique `{ boardId, nodeId }`, `nodeId` = UUID global, isolation stricte intra-board en V1. `boardId` interne reste la référence, `publicBoardId` (UUID opaque) sert aux publications/templates. Le node racine est toujours `root`, non supprimable ni déplaçable.
- Structure : `sys.shape` unique vérité (container/leaf), un leaf n’a jamais d’enfants, ordre strict. Seuls les tags noyau `structure/folder` et `structure/hierarchy` peuvent, de façon encadrée, promouvoir un `leaf` en `container` ; aucun tag ne peut rétrograder automatiquement un container en leaf.
- États : un item peut n’avoir **aucun** état principal, ou **exactement un** parmi `{ todo, doing, done, failed }` (exclusifs). `blocked` et `late` ne sont autorisés qu’avec `todo/doing` et sont retirés automatiquement à la transition vers `done/failed`. Combinaisons interdites rejetées (`done+blocked`, `done+failed`, etc.).
- Progression : champs par item, `progressMax` borné (≤ 10 000). `progressMax = 0/null` = progression inconnue. Invariant minimal : si un item possède à la fois `state/done` et une progression, alors `progressCurrent = progressMax` ; toute combinaison invalide est refusée (pas de correction silencieuse). Aucune agrégation par structure ; la seule agrégation V1 est une “readiness” = `min` des dépendances explicites.
- Relations : toute relation avec sémantique de dépendance (`depends=true`, incluant `rel/depends-on` et `rel/blocks`) appartient au même DAG acyclique ; `rel/linked` reste hors DAG.
- Droits : Teams est l’unique source de permissions. Aucun pack (Interactions, Logic, Community, Library, Activity) ne peut donner/retirer un droit effectif hors Teams.
- Interactions vs Logique : Interactions = couche de configuration locale porteur-centrée qui compile en règles Logic (moteur unique), scopes bornés, atomicité V1 ; Logique = règles globales, politique de board, peut fournir des triggers supplémentaires. Priorités/overrides définies dans Logic.tech.
- Publication : export/fork expurge Teams/assigned/données internes ; actions/règles publicables arrivent inactives et doivent être activées explicitement dans le board cible. Scheduler/logique désactivés par défaut à l’import. Community/Library sont positionnés en phase post‑V1.
- Activity : journal filtré par Teams ; aucun événement n’est visible sans droit de lecture ; références invisibles masquées, pas de fuite de quantités ou de nombres d’items.

## Décisions structurantes

- Commandes : toutes mutations via `POST /api/commands` (CommandBus/Arbitre/RulesEngine/Applier). Pas de flux REST mutants.
- Packs MCC : déclaratifs (tags/datasets/règles/slots UI), pas d’API back custom.
- Atomicité Interactions V1 : actions déclarées dans Interactions compilées en règles Logic porteur‑centrées, exécutées de manière atomique (plan validé puis appliqué en bloc) ; aucun mode best‑effort exposé, pas de commande spéciale hors pipeline standard.
- Acyclicité : structure parent/enfant et `rel/depends-on` (et relations porteuses de dépendance flaggées) doivent rester acycliques.

## Contrats transverses

- Sélection universelle : service unique, prévisualisation obligatoire. On distingue `UiSelection` (sélection front éphémère utilisée pour des actions UI best‑effort) et `DomainSelection` (scopes/filtres décrits dans les règles/actions, recalculés côté back au run). Pour Interactions/Logique, seule la DomainSelection compte ; si 0 cible ou cible non éditable → échec global. Pour les actions ponctuelles UI, best-effort avec avertissements. Sélection vide = exécution désactivée.
- Tags : préfixes réservés (`state/`, `rel/`, `resource/`, `type/`, `assigned/`, `sys/`, `event/`, `team/`…) interdits pour les tags utilisateur. Registre central unique des tags système.
- Progression/états : incohérences signalées (ex. eff=max sans `done`), jamais autocorrigées silencieusement. États invalides refusés avec code explicite.
- Permissions dans les runs automatiques : acteur = déclencheur ; chaque effet vérifié via Teams ; pas de bypass “système”. Interactions/Logique exécutées en mode atomique (tout ou rien). Pas de création d’actions planifiées en Interactions V1.
- Anti-boucles : budget de cascade (profondeur/effets) et mémo des règles/actions déjà appliquées dans la même cascade ; en cas de dépassement, la cascade est arrêtée et journalisée.

## Plan de mise en œuvre fonctionnel

- Fondations verrouillées (IDs, sélection, tags, temps).
- Packs métiers : Gestion (états/échéances/progression/ressources) → Relations → Interactions (atomicité V1) → Logic → Teams → Community/Library → Activity.
- Clôturer chaque pack fonctionnel avant d’entrer en technique ; maintenir ce document à jour en cas de décision transversale.
