> ⚠️ **MODE DEV STRICT (pas PROD)**  
> - **Aucune transition**, **aucun fallback**, **aucune rétro-compat**.  
> - Soit on règle un point proprement soit on n'y touche pas. pas de zone de : "transition ou entre deux".  
> - Toute contribution qui introduit une zone grise, un compromis ou un retour au legacy est **refusée**.

# CI Guards — Anti‑legacy & Routes mutantes

## But
Empêcher la réintroduction d’anti‑patterns (formes JSON legacy, routes mutantes hors périmètre) et détecter toute dérive structurelle.

## Règles actuelles
- Échec si un contrôleur utilise `Response::json([... 'error' => ...])` (forme legacy non canonique).
- Échec si un contrôleur retourne `Response::json(['status' => ...])` (forme succès legacy non canonique).
- Scan des routes mutantes dans `public/index.php`; seules les mutations de la **liste d’autorisation** sont acceptées:
  - `POST /api/commands`
  - `POST /api/admin/*`
  - `POST /api/auth/login`
  - `POST /api/auth/register`
  - `POST /api/dev/elevate-admin` (dev only)
  - `PUT /api/packs/config`

## Intégration
- Script: `tools/ci/guards.sh` (bash + ripgrep).
- À exécuter dans le pipeline avant tests.
- Toute violation retourne un code de sortie ≠ 0 et échoue la CI.

## Extensions possibles
- Grep pour forcer l’usage de `Response::ok/error` dans `src/Interfaces/Http/Controllers`.
- Règle interdisant les sorties non JSON (ou vérification de `Content-Type` dans les handlers sensibles).

## Script CI prêt-à-l’emploi

`tools/ci/guards.sh` :
```bash
#!/usr/bin/env bash
set -euo pipefail

fail=0

# 1) Interdire réponses legacy 'error' bricolées
if rg -n --hidden --glob '!vendor/**' "Response::json\\(\\s*\\[\\s*'error'\\s*=>" src/; then
  echo "[CI] Response::json([... 'error' => ...]) détecté — utiliser Response::error(...)" >&2
  fail=1
fi

# 2) Interdire routes mutantes hors liste d’autorisation
if rg -n --hidden --glob '!vendor/**' -e "->add\\((POST|PUT|PATCH|DELETE).*?/api/boards" public/index.php; then
  echo "[CI] Mutation REST /api/boards détectée — utiliser POST /api/commands" >&2
  fail=1
fi

# 3) Anti-legacy V2/V3 (heuristiques & registres magiques)
if rg -n --hidden --glob '!vendor/**' -e "inbox|first(-|\\s)?list|/api/modules|ModuleRegistry|CreateList|MoveList|UpdateItem" src/; then
  echo "[CI] Marqueurs legacy détectés" >&2
  fail=1
fi

# 4) Interdire forme succès legacy 'status'
if rg -n --hidden --glob '!vendor/**' "Response::json\\(\\s*\\[\\s*'status'\\s*=>" src/; then
  echo "[CI] Response::json(['status'=>...]) détecté — utiliser Response::ok(...)" >&2
  fail=1
fi

exit $fail
```
