> ⚠️ **MODE DEV STRICT (pas PROD)**  
> - **Aucune transition**, **aucun fallback**, **aucune rétro-compat**.  
> - Soit on règle un point proprement soit on n'y touche pas. pas de zone de : "transition ou entre deux".  
> - Toute contribution qui introduit une zone grise, un compromis ou un retour au legacy est **refusée**.

# HTTP & Routing — Kernel, Router, Mutations

## Kernel & Router
- `HttpKernel` compose une chaîne de middlewares puis délègue au `Router`.
- `Router` associe méthode+chemin à un handler (closures) et gere les variables d’URL.
- Réponse 404 par défaut: `Response::error('NOT_FOUND', ...)`.

## Middlewares (ordre)
1. `ErrorHandlingMiddleware` → convertit toute exception en JSON canonique.
2. `RateLimitMiddleware` → anti brute‑force auth.
3. `AuthMiddleware` → résout la session/utilisateur.
4. `CsrfMiddleware` → exige `X-CSRF-Token` sur mutations.

## Liste d’autorisation des routes mutantes (ligne rouge)
- Autorisées par défaut:
  - `POST /api/commands`
  - `POST /api/admin/*`
  - `POST /api/auth/login`
  - `POST /api/auth/register`
  - `POST /api/dev/elevate-admin` (dev only)
  - `PUT /api/packs/config`
- Toute autre mutation est interdite et doit être refusée en revue (et par les guards CI).

## Bonnes pratiques
- GET/HEAD servent les vues/app shells et les lectures JSON.
- Les flux métier passent par `/api/commands` (CommandBus) et renvoient toujours JSON canonique.
