import { createRichNotificationsStore, defaultRichState as defaultNotificationsState } from '../../../packages/ui/notifications-rich.js';

let getStore = null;
let controller = null;

export { defaultNotificationsState };

export function initNotifications(ctx) {
  if (!ctx?.store) {
    return;
  }
  getStore = () => ctx.store;
  controller = createRichNotificationsStore({
    getState: () => {
      const store = getStore?.();
      const state = store?.getState?.();
      return state?.notifications ?? defaultNotificationsState();
    },
    setState: (next) => {
      const store = getStore?.();
      if (!store?.setState) return;
      store.setState((prev) => ({
        ...prev,
        notifications: next,
      }));
    },
  });
}

export function toggleNotificationsTray(force = null) {
  if (!controller) return Promise.resolve();
  return controller.toggle(force);
}

export function openNotificationsTray() {
  if (!controller) return Promise.resolve();
  return controller.open();
}

export function closeNotificationsTray() {
  if (!controller) return;
  controller.close();
}

export function loadNotifications(mode = 'unread') {
  if (!controller) return Promise.resolve();
  return controller.load(mode);
}

export async function dismissNotification(id) {
  if (!controller) return;
  await controller.archiveMany([id]);
}

export async function dismissAllNotifications() {
  if (!controller) return;
  const state = controller.getState?.() ?? null;
  const ids = Array.isArray(state?.items) ? state.items.map(n => n.id) : [];
  if (ids.length) await controller.archiveMany(ids);
  controller.close?.();
}

export function renderNotificationsTray(state) {
  const notifications = state?.notifications ?? defaultNotificationsState();
  return controller?.render?.(notifications) ?? '';
}
