import { requestJson } from '../../../packages/services/http.js';

export async function fetchPacks() {
  try {
    return await requestJson('/api/packs/enabled', { method: 'GET' });
  } catch (error) {
    console.error('PACKS_FETCH_FAILED', error);
    return { enabled: [] };
  }
}

export async function fetchPacksManifest() {
  try {
    const res = await requestJson('/api/packs/manifest', { method: 'GET' });
    return {
      tags: Array.isArray(res?.tags) ? res.tags : [],
      rules: Array.isArray(res?.rules) ? res.rules : [],
      datasets: Array.isArray(res?.datasets) ? res.datasets : [],
    };
  } catch (error) {
    console.error('PACKS_MANIFEST_FETCH_FAILED', error);
    return { tags: [], rules: [], datasets: [] };
  }
}
