// Layout rendering extracted from main.js without logic changes
import { isAutosavePending, mapAutosaveStatus as autoMapAutosaveStatus } from '../autosave.js';
import { defaultNotificationsState as notifDefaultState } from '../notifications.js';
// Editor modal is now managed by a persistent manager; no direct injection here
import { renderFilterTags, renderColumn, escapeHtml } from './board-view.js';
import {
  renderBrand as renderGlobalBrand,
  renderUserMenu as renderGlobalUserMenu,
  renderNotificationButton as renderGlobalNotificationButton,
  renderTopbar as renderGlobalTopbar,
  renderActionsGroup as renderTopbarActionsGroup,
} from '../../../../packages/ui/global-topbar.js';

export function renderTopbar(state, boardView) {
  const user = state.session.user;
  const board = state.boards.find(b => String(b.id) === state.currentBoardId);
  const autosave = state.autosave ?? autoMapAutosaveStatus();
  const autosavePending = isAutosavePending() || autosave.status === 'pending';
  const userIsAdmin = isAdmin(user);
  const notifications = state.notifications ?? notifDefaultState();
  const unreadCount = Array.isArray(notifications.categories)
    ? notifications.categories.reduce((acc, c) => acc + (Number(c?.unread ?? 0) || 0), 0)
    : 0;
  const brandHtml = renderGlobalBrand({
    subtitle: board ? board.title : 'Mes boards',
  });
  const menuItems = [
    { id: 'open-account', label: 'Mon compte', icon: '👤' },
    { id: 'open-boards', label: 'Mes boards', icon: '📋' },
    ...(userIsAdmin ? [{ id: 'open-admin', label: 'Administration', icon: '🛠️' }] : []),
  ];
  const userMenuHtml = renderGlobalUserMenu(user, {
    items: menuItems,
    footer: [
      { id: 'logout', label: 'Déconnexion', kind: 'danger', icon: '🚪' },
    ],
  });
  const notificationButton = renderGlobalNotificationButton({
    action: 'open-notifications',
    count: unreadCount,
    open: !!notifications.open,
    title: 'Notifications',
  });
  const cluster = renderTopbarActionsGroup(`
    <button type="button" class="autosave-indicator" data-action="toggle-autosave" data-status="${autosave.status}" data-pending="${autosavePending ? 'true' : 'false'}" title="Détails de synchronisation">
      <span class="dot"></span>
      <span>${escapeHtml(autosave.message)}</span>
    </button>
    <button class="btn ghost" data-action="export-board">Exporter</button>
    <button class="btn ghost" data-action="import-board">Importer</button>
    <button class="btn btn--icon ghost focus-ring" data-action="open-file-library" aria-label="Mes fichiers">📁</button>
    <button class="btn btn--icon ghost focus-ring" data-action="open-board-config" aria-label="Configuration du board">⚙️</button>
  `, { className: 'board-topbar__cluster' });
  return renderGlobalTopbar({
    className: 'app-topbar--compact app-topbar--wrap',
    brand: brandHtml,
    actions: [cluster, notificationButton, userMenuHtml],
  });
}

export function renderSidebar(state, boardView) {
  const board = boardView ?? state.board;
  const workspaces = board?.workspaces ?? [];
  return `
    <aside class="sidebar">
      <div class="sidebar-section">
        <div class="sidebar-section__header">
          <h2>Workspaces</h2>
          <button type="button" class="btn btn--icon ghost focus-ring workspace-add-btn" data-action="create-workspace" data-dnd-ignore="true" aria-label="Nouveau workspace">＋</button>
          </div>
        <div class="workspace-list">
          ${workspaces.map(ws => {
            const title = escapeHtml(ws.title ?? 'Workspace');
            const active = board.activeWorkspaceId === ws.id ? 'active' : '';
            return `
              <div class="workspace-entry ${active}" data-workspace="${ws.id}">
                <button type="button" class="workspace-btn ${active}"
                  data-action="switch-workspace"
                  data-workspace="${ws.id}">
                  ${title}
                </button>
                <div class="workspace-entry__actions" data-dnd-ignore="true">
                  <button type="button" class="workspace-action-btn focus-ring" data-action="rename-workspace" data-workspace="${ws.id}" title="Renommer le workspace" aria-label="Renommer ${title}">✏️</button>
                  <button type="button" class="workspace-action-btn danger focus-ring" data-action="delete-workspace" data-workspace="${ws.id}" title="Supprimer le workspace" aria-label="Supprimer ${title}">🗑️</button>
                </div>
              </div>
            `;
          }).join('')}
        </div>
      </div>
      <div class="sidebar-section">
        <h2>Filtres</h2>
        <div class="filters">
          <div class="filter-tags">
            ${renderFilterTags(state)}
            <button data-action="filter-none" class="${state.filter.tags.includes('__NONE__') ? 'active' : ''}">Sans tag</button>
          </div>
        </div>
      </div>
    </aside>`;
}

export function renderMain(state, boardView) {
  const boardLike = boardView ?? state.board ?? {};
  const workspaces = Array.isArray(boardLike.workspaces) ? boardLike.workspaces : [];
  const activeId = state.board?.activeWorkspaceId ?? null;
  const workspace = workspaces.find(ws => ws.id === activeId) ?? workspaces[0] ?? null;
  if (!workspace) return '<main class="board-main"></main>';
  // Inject the filtered board into a shallow-cloned state for downstream renderers
  const viewState = { ...state, board: boardLike };
  return `
    <main class="board-main" data-board="${state.currentBoardId}">
      <div class="column-row" data-dropzone="true" data-dropzone-type="column" data-workspace="${workspace.id}">
        ${workspace.columns.map(col => renderColumn(col, viewState, workspace.id)).join('')}
        <button type="button" class="board-column board-column--add" data-action="create-column" data-dnd-ignore="true">
          <span class="board-column--add__icon">＋</span>
          <span class="board-column--add__label">Nouvelle colonne</span>
        </button>
      </div>
    </main>
  `;
}
// rich editor rendering provided by ./editor.js

function isAdmin(user) {
  const role = (user?.role ?? 'standard').toLowerCase();
  return role === 'admin' || role === 'superadmin';
}

// Empty state view (header + call to action)
export function renderEmpty(state) {
  return `
    ${renderTopbar(state, null)}
    <div class="board-layout">
      <div class="empty-board">
        <div class="ico">☁️</div>
        <h2>Créez votre premier board</h2>
        <p>Organisez vos projets dans un espace clair et modulaire.</p>
        <button class="btn primary" data-action="create-board">＋ Nouveau board</button>
      </div>
    </div>
  `;
}
