import { requestJson } from './http.js';

export async function fetchAccount() {
  return await requestJson('/api/account', { method: 'GET' });
}

export async function updateProfile({ pseudo }, csrf) {
  await requestJson('/api/commands', { method: 'POST', body: { type: 'Account.UpdateProfile', payload: { pseudo } } });
  return true;
}

export async function requestVerification(csrf) {
  return await requestJson('/api/commands', { method: 'POST', body: { type: 'Account.RequestVerification', payload: {} } });
}

export async function verifyEmail(token, csrf) {
  return await requestJson('/api/commands', { method: 'POST', body: { type: 'Account.Verify', payload: { token } } });
}

export async function redeemLicense(code, csrf) {
  const payload = await requestJson('/api/commands', { method: 'POST', body: { type: 'Account.RedeemLicense', payload: { code } } });
  if (payload?.success === false) {
    const error = new Error(payload?.error ?? 'LICENSE_REDEEM_FAILED');
    error.payload = payload; throw error;
  }
  return payload;
}
