const ROUTES = {
  boards: 'boards.html',
  board: 'board.html',
  account: 'account.html',
  modules: 'modules.html',
  admin: 'admin.html',
  auth: 'auth.html',
};

const BASE_URL = (() => {
  try {
    // `new URL('.', href)` returns the current directory with a trailing slash
    // and preserves the active origin, even when the app is served from a
    // nested folder or via alternate protocols (file://, ftp://, etc.).
    const base = new URL('.', window.location.href);
    base.hash = '';
    base.search = '';
    return base;
  } catch (error) {
    // Absolute fallback in case the current location cannot be parsed for any
    // reason. Using the href itself ensures a valid origin is retained.
    try {
      return new URL(window.location.href);
    } catch (_) {
      const fallbackOrigin = (typeof window.location.origin === 'string' && window.location.origin)
        ? window.location.origin
        : 'http://localhost/';
      return new URL('/', fallbackOrigin);
    }
  }
})();

function toUrl(path) {
  const target = typeof path === 'string' ? path.trim() : '';
  const relative = target.replace(/^\/+/, '');
  try {
    return new URL(relative || '', BASE_URL);
  } catch (_) {
    return new URL('/', BASE_URL);
  }
}

export function goToBoards() {
  navigate(toUrl(ROUTES.boards));
}

export function goToBoard(boardId) {
  const url = toUrl(ROUTES.board);
  if (boardId !== undefined && boardId !== null && String(boardId).trim() !== '') {
    url.searchParams.set('board', String(boardId));
  }
  navigate(url);
}

export function goToBoardNotifications() {
  const url = toUrl(ROUTES.board);
  url.hash = 'notifications';
  navigate(url);
}

export function goToAccount() {
  navigate(toUrl(ROUTES.account));
}

export function goToModules() {
  navigate(toUrl(ROUTES.modules));
}

export function goToAdmin() {
  navigate(toUrl(ROUTES.admin));
}

export function goToAuth() {
  navigate(toUrl(ROUTES.auth));
}

export function openExternal(url) {
  if (typeof url !== 'string' || !url) {
    return;
  }
  try {
    const target = new URL(url, BASE_URL);
    navigate(target);
  } catch (error) {
    console.warn('NAVIGATION_URL_INVALID', url, error);
  }
}

function navigate(url) {
  if (!(url instanceof URL)) {
    return;
  }
  window.location.assign(url.toString());
}
