import { goToAuth } from './navigation.js';
import { requestJson } from './http.js';

export async function fetchSession() {
  try {
    const session = await requestJson('/api/session', { method: 'GET' });
    if (!session || session.ok === false) {
      return { authenticated: false };
    }
    return session;
  } catch (error) {
    if (error?.status === 401 || error?.status === 403) {
      return { authenticated: false };
    }
    throw error;
  }
}

export async function ensureAuthenticated() {
  const session = await fetchSession();
  if (!session.authenticated) {
    goToAuth();
    return null;
  }
  return session;
}
