function renderBadges(el, ctx) {
  const { item } = ctx;
  const tags = Array.isArray(item?.tags) ? item.tags : [];
  const dataset = ctx?.datasets?.categories ?? null;
  const byKey = dataset?.byKey ?? {};
  const items = Array.isArray(dataset?.items) ? dataset.items : [];
  const resolveDef = (key) => {
    if (byKey && byKey[key]) {
      return byKey[key];
    }
    return items.find(entry => entry?.key === key) ?? null;
  };

  el.innerHTML = '';

  tags
    .filter(tag => {
      const key = String(tag?.key ?? tag?.k ?? '');
      return key.startsWith('category/');
    })
    .forEach(tag => {
      const key = String(tag?.key ?? tag?.k ?? '');
      const def = resolveDef(key) ?? {};
      const label = typeof def.label === 'string' && def.label.trim() ? def.label.trim() : key.split('/')[1] || 'Catégorie';
      const themeColor = typeof def.themeColor === 'string' && def.themeColor.trim() ? def.themeColor.trim() : '#64748b';
      const icon = typeof def.icon === 'string' && def.icon.trim() ? def.icon.trim() : '';
      const iconKind = detectIconKind(icon);

      const badge = document.createElement('span');
      badge.className = 'sb-badge';
      badge.style.setProperty('--badge-color', themeColor);
      badge.title = label;
      badge.dataset.dndIgnore = 'true';

      if (icon && iconKind === 'image') {
        const img = document.createElement('img');
        img.src = icon;
        img.alt = label;
        img.loading = 'lazy';
        img.decoding = 'async';
        badge.appendChild(img);
      } else {
        const glyph = icon && iconKind === 'glyph' ? icon : label.charAt(0).toUpperCase();
        const fallback = document.createElement('span');
        fallback.className = 'sb-badge__fallback';
        fallback.textContent = glyph.slice(0, 3);
        badge.appendChild(fallback);
      }

      el.appendChild(badge);
    });
}

export default [
  { id: 'org:badges', slot: 'item.badges', order: 10, render: renderBadges }
];

function detectIconKind(icon) {
  if (!icon || typeof icon !== 'string') {
    return 'none';
  }
  const trimmed = icon.trim();
  if (!trimmed) return 'none';
  if (/^(https?:)?\//.test(trimmed) || /\.(svg|png|jpg|jpeg|webp)(\?.*)?$/i.test(trimmed)) {
    return 'image';
  }
  if (trimmed.length <= 4) {
    return 'glyph';
  }
  return 'glyph';
}


