<?php

declare(strict_types=1);

namespace Skyboard\Application\Commands;

final class AddTagV3Command implements Command
{
    /**
     * @param array{key?:string,k?:string,kind?:string,label?:string,icon?:string,color?:string|null,value?:string,sys?:bool,category?:string} $tag
     */
    public function __construct(
        private readonly string $boardId,
        private readonly string $actorId,
        private readonly string $nodeId,
        private readonly array $tag
    ) {
    }

    public function boardId(): ?string { return $this->boardId; }
    public function actorId(): string { return $this->actorId; }
    public function nodeId(): string { return $this->nodeId; }
    /** @return array<string,mixed> */
    public function tag(): array { return $this->tag; }
}


