<?php

declare(strict_types=1);

namespace Skyboard\Application\Commands;

final class CreateColumnCommand implements Command
{
    public function __construct(
        private readonly string $boardId,
        private readonly string $actorId,
        private readonly string $workspaceId,
        private readonly string $title
    ) {
    }

    public function boardId(): ?string
    {
        return $this->boardId;
    }

    public function actorId(): string
    {
        return $this->actorId;
    }

    public function workspaceId(): string
    {
        return $this->workspaceId;
    }

    public function title(): string
    {
        return $this->title;
    }
}

