<?php

declare(strict_types=1);

namespace Skyboard\Application\Handlers;

use Skyboard\Application\Commands\Command;
use Skyboard\Application\Commands\CreateWorkspaceCommand;
use Skyboard\Application\Commands\ProposedChange;
use Skyboard\Domain\Boards\BoardPatch;
use Skyboard\Domain\Shared\Identifiers;

final class CreateWorkspaceHandler implements CommandHandler
{
    public function handle(Command $command): ProposedChange
    {
        if (!$command instanceof CreateWorkspaceCommand) {
            throw new \InvalidArgumentException('Unsupported command');
        }
        $operation = [
            'op' => 'node.create',
            'parentId' => 'root',
            'nodeId' => Identifiers::new(),
            'title' => $command->title(),
            'sys' => ['shape' => 'container'],
        ];
        $events = [[
            'name' => 'WorkspaceWillBeCreated',
            'boardId' => $command->boardId(),
            'actorId' => $command->actorId(),
            'context' => $operation,
        ]];
        $patch = new BoardPatch($command->boardId(), [$operation]);
        return new ProposedChange($patch, $events);
    }
}

