<?php

declare(strict_types=1);

namespace Skyboard\Application\Handlers;

use Skyboard\Application\Commands\Command;
use Skyboard\Application\Commands\MoveColumnCommand;
use Skyboard\Application\Commands\ProposedChange;
use Skyboard\Domain\Boards\BoardPatch;

final class MoveColumnHandler implements CommandHandler
{
    public function handle(Command $command): ProposedChange
    {
        if (!$command instanceof MoveColumnCommand) {
            throw new \InvalidArgumentException('Unsupported command');
        }
        $operation = [
            'op' => 'node.move',
            'nodeId' => $command->columnId(),
            'toParentId' => $command->workspaceId(),
            'toIndex' => $command->position(),
        ];
        $events = [[
            'name' => 'ColumnWillBeMoved',
            'boardId' => $command->boardId(),
            'actorId' => $command->actorId(),
            'context' => $operation,
        ]];
        $patch = new BoardPatch($command->boardId(), [$operation]);
        return new ProposedChange($patch, $events);
    }
}

