<?php

declare(strict_types=1);

namespace Skyboard\Application\Handlers;

use Skyboard\Application\Commands\Command;
use Skyboard\Application\Commands\ProposedChange;
use Skyboard\Application\Commands\RenameColumnCommand;
use Skyboard\Domain\Boards\BoardPatch;

final class RenameColumnHandler implements CommandHandler
{
    public function handle(Command $command): ProposedChange
    {
        if (!$command instanceof RenameColumnCommand) {
            throw new \InvalidArgumentException('Unsupported command');
        }
        $operation = [
            'op' => 'column.rename',
            'workspaceId' => $command->workspaceId(),
            'columnId' => $command->columnId(),
            'title' => $command->title(),
        ];
        $events = [[
            'name' => 'ColumnWillBeRenamed',
            'boardId' => $command->boardId(),
            'actorId' => $command->actorId(),
            'context' => $operation,
        ]];
        $patch = new BoardPatch($command->boardId(), [$operation]);
        return new ProposedChange($patch, $events);
    }
}

