<?php

declare(strict_types=1);

namespace Skyboard\Application\Handlers;

use Skyboard\Application\Commands\Command;
use Skyboard\Application\Commands\ProposedChange;
use Skyboard\Application\Commands\RenameWorkspaceCommand;
use Skyboard\Domain\Boards\BoardPatch;

final class RenameWorkspaceHandler implements CommandHandler
{
    public function handle(Command $command): ProposedChange
    {
        if (!$command instanceof RenameWorkspaceCommand) {
            throw new \InvalidArgumentException('Unsupported command');
        }
        $operation = [
            'op' => 'workspace.rename',
            'workspaceId' => $command->workspaceId(),
            'title' => $command->title(),
        ];
        $events = [[
            'name' => 'WorkspaceWillBeRenamed',
            'boardId' => $command->boardId(),
            'actorId' => $command->actorId(),
            'context' => $operation,
        ]];
        $patch = new BoardPatch($command->boardId(), [$operation]);
        return new ProposedChange($patch, $events);
    }
}

