<?php

declare(strict_types=1);

namespace Skyboard\Application\NonBoard\Handlers;

use Skyboard\Application\NonBoard\NonBoardHandler;
use Skyboard\Application\Services\EmailVerificationService;
use Skyboard\Infrastructure\Http\Request;
use Skyboard\Infrastructure\Http\Response;

final class AccountVerifyHandler implements NonBoardHandler
{
    public function __construct(private readonly EmailVerificationService $verification)
    {
    }

    public function handle(int $userId, array $payload, Request $request): Response
    {
        $token = (string) ($payload['token'] ?? '');
        if ($token === '') {
            return Response::error('TOKEN_REQUIRED', 'Jeton requis.', [], 422);
        }
        $ok = $this->verification->verify($userId, $token);
        return Response::ok(['ok' => (bool) $ok]);
    }
}

