<?php

declare(strict_types=1);

namespace Skyboard\Application\NonBoard\Handlers;

use PDO;
use Skyboard\Application\NonBoard\NonBoardHandler;
use Skyboard\Infrastructure\Http\Request;
use Skyboard\Infrastructure\Http\Response;
use Skyboard\Infrastructure\Persistence\DatabaseConnection;

final class ActivityMarkSeenHandler implements NonBoardHandler
{
    public function __construct(private readonly DatabaseConnection $connection)
    {
    }

    public function handle(int $userId, array $payload, Request $request): Response
    {
        $ids = $this->extractIds($payload['ids'] ?? null);
        if ($ids === []) {
            return Response::ok();
        }
        $pdo = $this->connection->pdo();
        $stmt = $pdo->prepare('INSERT INTO activity_user_state(user_id, event_id, seen_at) VALUES(:user, :id, :ts)
                               ON DUPLICATE KEY UPDATE seen_at = IF(seen_at IS NULL, VALUES(seen_at), seen_at)');
        $ts = time();
        foreach ($ids as $id) {
            $stmt->execute(['user' => $userId, 'id' => $id, 'ts' => $ts]);
        }
        return Response::ok();
    }

    /**
     * @param mixed $value
     * @return list<int>
     */
    private function extractIds(mixed $value): array
    {
        if (is_string($value)) {
            $decoded = json_decode($value, true);
            if (is_array($decoded)) $value = $decoded;
        }
        if (!is_array($value)) return [];
        $ids = [];
        foreach ($value as $candidate) {
            $id = (int) $candidate;
            if ($id > 0) $ids[] = $id;
        }
        return array_values(array_unique($ids));
    }
}

