<?php

declare(strict_types=1);

namespace Skyboard\Application\NonBoard\Handlers;

use Skyboard\Application\NonBoard\NonBoardHandler;
use Skyboard\Application\Services\BoardCatalog;
use Skyboard\Infrastructure\Http\Request;
use Skyboard\Infrastructure\Http\Response;

final class BoardCreateHandler implements NonBoardHandler
{
    public function __construct(private readonly BoardCatalog $boards)
    {
    }

    public function handle(int $userId, array $payload, Request $request): Response
    {
        $title = trim((string) ($payload['title'] ?? 'Nouveau board'));
        $board = $this->boards->create($userId, $title === '' ? 'Nouveau board' : $title);
        return Response::ok(['board' => $board]);
    }
}

