<?php

declare(strict_types=1);

namespace Skyboard\Application\NonBoard\Handlers;

use Skyboard\Application\NonBoard\NonBoardHandler;
use Skyboard\Application\Services\BoardRulesService;
use Skyboard\Infrastructure\Http\Request;
use Skyboard\Infrastructure\Http\Response;
use InvalidArgumentException;
use Throwable;

final class BoardRulesImportHandler implements NonBoardHandler
{
    public function __construct(private readonly BoardRulesService $service)
    {
    }

    public function handle(int $userId, array $payload, Request $request): Response
    {
        $boardId = (int) ($payload['boardId'] ?? 0);
        $rules = $payload['rules'] ?? null;
        if ($boardId <= 0 || !is_array($rules)) {
            return Response::error('INVALID_PAYLOAD', 'Données invalides.', [], 422);
        }
        try {
            $this->service->replace($boardId, $userId, $rules);
        } catch (InvalidArgumentException $e) {
            return Response::error('NOT_FOUND', $e->getMessage(), [], 404);
        } catch (Throwable $e) {
            return Response::error('IMPORT_FAILED', $e->getMessage(), [], 422);
        }
        return Response::ok([
            'importedAt' => gmdate('c'),
            'count' => count($rules),
        ]);
    }
}

