<?php

declare(strict_types=1);

namespace Skyboard\Application\NonBoard\Handlers;

use Skyboard\Application\NonBoard\NonBoardHandler;
use Skyboard\Application\Services\UserFileService;
use Skyboard\Infrastructure\Http\Request;
use Skyboard\Infrastructure\Http\Response;

final class FileCreateFolderHandler implements NonBoardHandler
{
    public function __construct(private readonly UserFileService $files)
    {
    }

    public function handle(int $userId, array $payload, Request $request): Response
    {
        $name = trim((string) ($payload['name'] ?? ''));
        if ($name === '') return Response::error('INVALID_PAYLOAD', 'Nom de dossier requis.', [], 422);
        $parent = $payload['parentFolderId'] ?? null;
        $parentId = is_string($parent) ? $parent : null;
        $folder = $this->files->createFolder($userId, $name, $parentId);
        return Response::ok(['folder' => $folder], 201);
    }
}

