<?php

declare(strict_types=1);

namespace Skyboard\Application\NonBoard\Handlers;

use Skyboard\Application\NonBoard\NonBoardHandler;
use Skyboard\Application\Services\UserFileService;
use Skyboard\Infrastructure\Http\Request;
use Skyboard\Infrastructure\Http\Response;

final class FileDeleteHandler implements NonBoardHandler
{
    public function __construct(private readonly UserFileService $files)
    {
    }

    public function handle(int $userId, array $payload, Request $request): Response
    {
        $fileId = (string) ($payload['fileId'] ?? '');
        if ($fileId === '') return Response::error('INVALID_FILE_ID', 'Identifiant de fichier invalide.', [], 422);
        $this->files->delete($userId, $fileId);
        return Response::ok(['deleted' => true]);
    }
}

