<?php

declare(strict_types=1);

namespace Skyboard\Application\NonBoard\Handlers;

use Skyboard\Application\NonBoard\NonBoardHandler;
use Skyboard\Application\Services\UserFileService;
use Skyboard\Infrastructure\Http\Request;
use Skyboard\Infrastructure\Http\Response;

final class FileRenameFolderHandler implements NonBoardHandler
{
    public function __construct(private readonly UserFileService $files)
    {
    }

    public function handle(int $userId, array $payload, Request $request): Response
    {
        $folderId = (string) ($payload['folderId'] ?? '');
        $name = trim((string) ($payload['name'] ?? ''));
        if ($folderId === '' || $name === '') {
            return Response::error('INVALID_PAYLOAD', 'Données invalides.', [], 422);
        }
        $folder = $this->files->renameFolder($userId, $folderId, $name);
        return Response::ok(['folder' => $folder]);
    }
}

