<?php

declare(strict_types=1);

namespace Skyboard\Application\NonBoard\Handlers;

use Skyboard\Application\NonBoard\NonBoardHandler;
use Skyboard\Application\Services\UserFileService;
use Skyboard\Infrastructure\Http\Request;
use Skyboard\Infrastructure\Http\Response;

final class FileRenameHandler implements NonBoardHandler
{
    public function __construct(private readonly UserFileService $files)
    {
    }

    public function handle(int $userId, array $payload, Request $request): Response
    {
        $fileId = (string) ($payload['fileId'] ?? '');
        $name = trim((string) ($payload['name'] ?? ''));
        if ($fileId === '' || $name === '') return Response::error('INVALID_PAYLOAD', 'Données invalides.', [], 422);
        $file = $this->files->rename($userId, $fileId, $name);
        return Response::ok(['file' => $file]);
    }
}

