<?php

declare(strict_types=1);

namespace Skyboard\Application\NonBoard\Handlers;

use Skyboard\Application\NonBoard\NonBoardHandler;
use Skyboard\Application\Services\UserFileService;
use Skyboard\Infrastructure\Http\Request;
use Skyboard\Infrastructure\Http\Response;

final class FileUpdateContentHandler implements NonBoardHandler
{
    public function __construct(private readonly UserFileService $files)
    {
    }

    public function handle(int $userId, array $payload, Request $request): Response
    {
        $fileId = (string) ($payload['fileId'] ?? '');
        if ($fileId === '') return Response::error('INVALID_FILE_ID', 'Identifiant de fichier invalide.', [], 422);
        $result = $this->files->writeContent($userId, $fileId, [
            'content' => (string) ($payload['content'] ?? ''),
            'checksum' => (string) ($payload['checksum'] ?? ''),
            'kind' => (string) ($payload['kind'] ?? ''),
            'format' => (string) ($payload['format'] ?? ''),
            'mimeType' => (string) ($payload['mimeType'] ?? ''),
        ]);
        return Response::ok(['file' => $result['file'], 'content' => $result['content']]);
    }
}

