<?php

declare(strict_types=1);

namespace Skyboard\Application\NonBoard\Handlers;

use Skyboard\Application\NonBoard\NonBoardHandler;
use Skyboard\Infrastructure\Http\Request;
use Skyboard\Infrastructure\Http\Response;
use Skyboard\Infrastructure\Persistence\DatabaseConnection;

final class NotificationDeleteForUserHandler implements NonBoardHandler
{
    public function __construct(private readonly DatabaseConnection $connection)
    {
    }

    public function handle(int $userId, array $payload, Request $request): Response
    {
        $id = isset($payload['id']) ? (int) $payload['id'] : 0;
        if ($id <= 0) {
            return Response::error('INVALID_PAYLOAD', 'Identifiant invalide.', [], 422);
        }
        $pdo = $this->connection->pdo();
        $stmt = $pdo->prepare('INSERT INTO notification_user_state(user_id, notification_id, deleted_at) VALUES(:user, :id, :ts)
                               ON DUPLICATE KEY UPDATE deleted_at = VALUES(deleted_at)');
        $stmt->execute(['user' => $userId, 'id' => $id, 'ts' => time()]);
        return Response::ok();
    }
}

