<?php

declare(strict_types=1);

namespace Skyboard\Application\NonBoard\Handlers;

use Skyboard\Application\NonBoard\NonBoardHandler;
use Skyboard\Infrastructure\Http\Request;
use Skyboard\Infrastructure\Http\Response;
use Skyboard\Infrastructure\Persistence\DatabaseConnection;

final class UserDataSetKeyHandler implements NonBoardHandler
{
    public function __construct(private readonly DatabaseConnection $connection)
    {
    }

    public function handle(int $userId, array $payload, Request $request): Response
    {
        $namespace = trim((string) ($payload['namespace'] ?? 'prefs'));
        $key = trim((string) ($payload['key'] ?? ''));
        $value = $payload['value'] ?? true;

        if ($key === '' || $namespace === '') {
            return Response::error('INVALID_PAYLOAD', 'namespace et key requis.', [], 422);
        }

        $pdo = $this->connection->pdo();
        $stmt = $pdo->prepare(
            'INSERT INTO user_data(user_id, namespace, `key`, value_json, updated_at)
             VALUES(:u, :ns, :k, :v, :ts)
             ON DUPLICATE KEY UPDATE value_json = VALUES(value_json), updated_at = VALUES(updated_at)'
        );
        $stmt->execute([
            'u' => $userId,
            'ns' => $namespace,
            'k' => $key,
            'v' => json_encode($value, JSON_UNESCAPED_UNICODE|JSON_UNESCAPED_SLASHES),
            'ts' => time(),
        ]);

        return Response::ok();
    }
}

