<?php

declare(strict_types=1);

namespace Skyboard\Application\NonBoard\Handlers;

use Skyboard\Application\NonBoard\NonBoardHandler;
use Skyboard\Infrastructure\Http\Request;
use Skyboard\Infrastructure\Http\Response;
use Skyboard\Infrastructure\Persistence\DatabaseConnection;

final class UserUnsubscribeCategoryHandler implements NonBoardHandler
{
    public function __construct(private readonly DatabaseConnection $connection)
    {
    }

    public function handle(int $userId, array $payload, Request $request): Response
    {
        $categoryId = isset($payload['categoryId']) ? (int) $payload['categoryId'] : 0;
        if ($categoryId <= 0) {
            return Response::error('INVALID_PAYLOAD', 'categoryId requis.', [], 422);
        }
        $pdo = $this->connection->pdo();
        $exists = $pdo->prepare('SELECT 1 FROM notification_categories WHERE id = :id');
        $exists->execute(['id' => $categoryId]);
        if (!$exists->fetchColumn()) {
            return Response::error('NOT_FOUND', 'Catégorie introuvable.', [], 404);
        }
        $stmt = $pdo->prepare('INSERT INTO user_subscriptions(user_id, category_id, subscribed, created_at)
                               VALUES(:user, :cat, 0, :now)
                               ON DUPLICATE KEY UPDATE subscribed = VALUES(subscribed)');
        $stmt->execute(['user' => $userId, 'cat' => $categoryId, 'now' => time()]);
        return Response::ok();
    }
}

