<?php

declare(strict_types=1);

namespace Skyboard\Application\NonBoard;

use Skyboard\Infrastructure\Http\Request;
use Skyboard\Infrastructure\Http\Response;

final class NonBoardBus
{
    /** @var array<string, NonBoardHandler> */
    private array $handlers = [];

    public function register(string $type, NonBoardHandler $handler): void
    {
        $this->handlers[$type] = $handler;
    }

    /**
     * @param array<string,mixed> $payload
     */
    public function dispatch(string $type, array $payload, Request $request, int $userId): Response
    {
        $handler = $this->handlers[$type] ?? null;
        if (!$handler) {
            return Response::error('UNKNOWN_COMMAND', 'Commande inconnue.', [], 422);
        }
        return $handler->handle($userId, $payload, $request);
    }
}

