<?php

declare(strict_types=1);

namespace Skyboard\Application\Services;

use RuntimeException;

final class StructureTagReactionRefused extends RuntimeException
{
    public function __construct(
        private readonly string $reason,
        string $message,
        private readonly array $details = []
    ) {
        parent::__construct($message);
    }

    public function reason(): string
    {
        return $this->reason;
    }

    /**
     * @return array<string,mixed>
     */
    public function details(): array
    {
        return $this->details;
    }
}
