<?php

declare(strict_types=1);

namespace Skyboard\Application\Services;

use RuntimeException;

final class UserFileException extends RuntimeException
{
    private string $errorCode;
    private int $status;
    /**
     * @var array<string,mixed>
     */
    private array $details;

    /**
     * @param array<string,mixed> $details
     */
    public function __construct(string $errorCode, string $message, int $status = 400, array $details = [])
    {
        parent::__construct($message, $status);
        $this->errorCode = $errorCode;
        $this->status = $status;
        $this->details = $details;
    }

    public function errorCode(): string
    {
        return $this->errorCode;
    }

    public function status(): int
    {
        return $this->status;
    }

    /**
     * @return array<string,mixed>
     */
    public function details(): array
    {
        return $this->details;
    }
}
