<?php

declare(strict_types=1);

namespace Skyboard\Application\Services;

use Skyboard\Domain\UserFiles\UserFileFolder;

interface UserFileFolderRepository
{
    /**
     * @return list<UserFileFolder>
     */
    public function listForUser(int $userId): array;

    public function insert(UserFileFolder $folder): UserFileFolder;

    public function findByPublicId(int $userId, string $publicId): ?UserFileFolder;

    public function update(UserFileFolder $folder): void;

    public function delete(UserFileFolder $folder): void;

    public function countFilesInFolder(int $userId, int $folderId): int;

    public function countSubFolders(int $userId, int $parentId): int;
}
