<?php

declare(strict_types=1);

namespace Skyboard\Domain\Boards;

final class BoardSnapshot
{
    /**
     * @param list<array{revision:int,updatedAt:int}> $history
     */
    public function __construct(
        private readonly BoardState $state,
        private readonly int $revision,
        private readonly int $updatedAt,
        private readonly array $history = []
    ) {
    }

    public function state(): BoardState
    {
        return $this->state;
    }

    public function revision(): int
    {
        return $this->revision;
    }

    public function updatedAt(): int
    {
        return $this->updatedAt;
    }

    /**
     * @return list<array{revision:int,updatedAt:int}>
     */
    public function history(): array
    {
        return $this->history;
    }
}
