<?php

declare(strict_types=1);

namespace Skyboard\Domain\Rules;

use Skyboard\Infrastructure\Packs\RulesCatalog;

final class CompositeRulesProvider implements RulesProvider
{
    /**
     * @param list<RuleDefinition> $systemRules
     * @param list<RulesProvider> $providers
     */
    public function __construct(
        private readonly array $systemRules,
        private readonly array $providers = [],
        private readonly ?RulesCatalog $packRules = null,
        private readonly array $enabledPacks = []
    ) {
    }

    /**
     * @return list<RuleDefinition>
     */
    public function forContext(string $boardId, string $actorId): array
    {
        $set = new RuleSet();
        
        // Strate system (0-49)
        $set->merge($this->systemRules);
        
        // Strate packs (50-89)
        if ($this->packRules !== null) {
            $packRules = $this->packRules->getEnabledRules($this->enabledPacks);
            $set->merge($packRules);
        }
        
        // Strate user (90-129)
        foreach ($this->providers as $provider) {
            foreach ($provider->forContext($boardId, $actorId) as $rule) {
                $set->add($rule);
            }
        }

        return $set->ordered();
    }
}
