<?php

declare(strict_types=1);

namespace Skyboard\Domain\Rules\Projector;

use Skyboard\Application\Commands\Command;
use Skyboard\Application\Commands\ProposedChange;
use Skyboard\Domain\Boards\BoardTraversal;
use Skyboard\Domain\Rules\RuleContextProjector;

final class OperationTargetProjector implements RuleContextProjector
{
    public function project(
        array $context,
        ?array $board,
        Command $command,
        ProposedChange $change,
        array $operations,
        int $operationIndex
    ): array {
        if ($board === null) {
            return [];
        }

        $operation = $operations[$operationIndex] ?? [];
        $scope = (string) ($operation['scope'] ?? ($operation['targetScope'] ?? ''));
        $targetId = (string) ($operation['targetId'] ?? ($operation['itemId'] ?? $operation['listId'] ?? $operation['workspaceId'] ?? ''));
        if ($scope === '') {
            $scope = $this->inferScope($operation);
        }

        if ($targetId === '') {
            return [];
        }

        $payload = [];
        // v3: scope unifié par node; on expose un target.node
        $node = BoardTraversal::findNode($board, $targetId);
        if ($node !== null) {
            $payload['target'] = [
                'scope' => 'item',
                'node' => $node,
            ];
        }

        return $payload;
    }

    /**
     * @param array<string,mixed> $operation
     */
    private function inferScope(array $operation): string
    {
        if (isset($operation['itemId']) || ($operation['target'] ?? null) === 'item') {
            return 'item';
        }
        if (isset($operation['listId']) || ($operation['target'] ?? null) === 'list') {
            return 'list';
        }
        if (isset($operation['workspaceId']) || ($operation['target'] ?? null) === 'workspace') {
            return 'workspace';
        }

        return 'item';
    }
}
