<?php

declare(strict_types=1);

namespace Skyboard\Domain\Rules\Projector;

use Skyboard\Application\Commands\Command;
use Skyboard\Application\Commands\ProposedChange;
use Skyboard\Domain\Boards\BoardTraversal;
use Skyboard\Domain\Rules\RuleContextProjector;

final class TagSnapshotProjector implements RuleContextProjector
{
    public function project(
        array $context,
        ?array $board,
        Command $command,
        ProposedChange $change,
        array $operations,
        int $operationIndex
    ): array {
        if ($board === null) {
            return [];
        }

        $operation = $operations[$operationIndex] ?? [];
        $scope = (string) ($operation['scope'] ?? '');
        $targetId = (string) ($operation['targetId'] ?? '');
        if ($scope === '' || $targetId === '') {
            return [];
        }

        $tags = BoardTraversal::tagsForTarget($board, $scope, $targetId);
        return ['targetTags' => $tags];
    }
}
