<?php

declare(strict_types=1);

namespace Skyboard\Domain\Rules;

use Skyboard\Application\Commands\Command;
use Skyboard\Application\Commands\ProposedChange;

interface RuleContextProjector
{
    /**
     * @param array<string,mixed> $context
     * @param array<string,mixed>|null $board
     * @param list<array<string,mixed>> $operations
     *
     * @return array<string,mixed> Additional context keys to merge
     */
    public function project(
        array $context,
        ?array $board,
        Command $command,
        ProposedChange $change,
        array $operations,
        int $operationIndex
    ): array;
}
