<?php

declare(strict_types=1);

namespace Skyboard\Domain\Rules;

final class RuleDictionary
{
    /** @var array<string,string> */
    private array $messages = [];

    public function registerDefinition(RuleDefinition $rule): void
    {
        $onVeto = $rule->onVeto();
        if (is_array($onVeto)) {
            $this->register($onVeto['reasonId'] ?? null, $onVeto['message'] ?? null);
        }

        foreach ($rule->actions() as $action) {
            $type = (string) ($action['type'] ?? '');
            if ($type === '') {
                continue;
            }
            if ($type === 'reject' || $type === 'veto') {
                $this->register($action['reasonId'] ?? null, $action['message'] ?? null);
            }
        }
    }

    public function register(?string $reasonId, ?string $message): void
    {
        $reason = is_string($reasonId) ? trim($reasonId) : '';
        if ($reason === '') {
            return;
        }
        if (array_key_exists($reason, $this->messages)) {
            return;
        }
        if ($message === null) {
            return;
        }
        $text = trim((string) $message);
        if ($text === '') {
            return;
        }
        $this->messages[$reason] = $text;
    }

    public function explain(string $reasonId): ?string
    {
        return $this->messages[$reasonId] ?? null;
    }

    /**
     * @return array<string,string>
     */
    public function all(): array
    {
        return $this->messages;
    }
}

