<?php

declare(strict_types=1);

namespace Skyboard\Domain\Rules;

final class RuleScope
{
    public const SYSTEM = 'system';
    public const MODULE = 'module';
    public const BOARD = 'board';
    public const WORKSPACE = 'workspace';
    public const USER = 'user';
    public const CUSTOM = '__custom__';

    /**
     * Strates ordonnées du plus prioritaire au moins prioritaire.
     * Modules futurs peuvent enregistrer leur propre scope – ils seront rangés après les connus.
     */
    private const PRIORITY = [
        self::SYSTEM => 500,
        self::MODULE => 400,
        self::BOARD => 300,
        self::WORKSPACE => 200,
        self::USER => 100,
    ];

    public static function weight(string $scope): int
    {
        return self::PRIORITY[$scope] ?? 0;
    }

    /**
     * @return list<string>
     */
    public static function ordered(): array
    {
        return [
            self::SYSTEM,
            self::MODULE,
            self::BOARD,
            self::WORKSPACE,
            self::USER,
        ];
    }
}
