<?php

declare(strict_types=1);

namespace Skyboard\Domain\Rules;

final class RuleSet
{
    /** @var array<string,RuleDefinition> */
    private array $definitions = [];

    public function add(RuleDefinition $definition): void
    {
        $id = $definition->id();
        if ($id === '') {
            return;
        }
        $this->definitions[$id] = $definition;
    }

    /**
     * @param iterable<RuleDefinition> $definitions
     */
    public function merge(iterable $definitions): void
    {
        foreach ($definitions as $definition) {
            $this->add($definition);
        }
    }

    /**
     * @return list<RuleDefinition>
     */
    public function ordered(): array
    {
        $definitions = array_values($this->definitions);
        usort($definitions, static function (RuleDefinition $a, RuleDefinition $b): int {
            $weightA = RuleScope::weight($a->scope());
            $weightB = RuleScope::weight($b->scope());
            if ($weightA === $weightB) {
                $priorityA = $a->priority();
                $priorityB = $b->priority();
                if ($priorityA === $priorityB) {
                    return strcmp($a->id(), $b->id());
                }
                return $priorityB <=> $priorityA;
            }

            return $weightB <=> $weightA;
        });

        return $definitions;
    }
}
