<?php

declare(strict_types=1);

namespace Skyboard\Domain\Rules;

use Skyboard\Domain\Boards\BoardPatch;

final class RulesEngineResult
{
    public function __construct(
        private readonly bool $rejected,
        private readonly ?BoardPatch $patch,
        private readonly ?string $reasonId,
        private readonly ?string $message,
        private readonly RuleEvaluationTrace $trace
    ) {
    }

    public static function accepted(BoardPatch $patch, RuleEvaluationTrace $trace): self
    {
        return new self(false, $patch, null, null, $trace);
    }

    public static function rejected(string $reasonId, ?string $message, RuleEvaluationTrace $trace): self
    {
        return new self(true, null, $reasonId, $message, $trace);
    }

    public function isRejected(): bool
    {
        return $this->rejected;
    }

    public function patch(): BoardPatch
    {
        if ($this->patch === null) {
            throw new \RuntimeException('Rules engine rejected patch');
        }
        return $this->patch;
    }

    public function reasonId(): ?string
    {
        return $this->reasonId;
    }

    public function message(): ?string
    {
        return $this->message;
    }

    public function trace(): RuleEvaluationTrace
    {
        return $this->trace;
    }
}

