<?php

declare(strict_types=1);

namespace Skyboard\Infrastructure\Http;

use Closure;

final class HttpKernel
{
    /** @var list<callable(Request, Closure): Response> */
    private array $middlewares = [];
    private Router $router;

    public function __construct(Router $router)
    {
        $this->router = $router;
    }

    /**
     * @param callable(Request, Closure): Response $middleware
     */
    public function addMiddleware(callable $middleware): void
    {
        $this->middlewares[] = $middleware;
    }

    public function handle(Request $request): Response
    {
        $middlewareChain = array_reduce(
            array_reverse($this->middlewares),
            function (Closure $next, callable $middleware): Closure {
                return function (Request $request) use ($middleware, $next) {
                    return $middleware($request, $next);
                };
            },
            function (Request $request): Response {
                $response = $this->router->dispatch($request);
                if ($response === null) {
                    return Response::error('NOT_FOUND', 'Ressource introuvable.', [], 404);
                }
                return $response;
            }
        );

        return $middlewareChain($request);
    }
}
