<?php

declare(strict_types=1);

namespace Skyboard\Infrastructure\Logging;

final class CommandAuditLogger
{
    private string $logFile;

    public function __construct(?string $logFile = null)
    {
        $this->logFile = $logFile ?? \Skyboard\storage_path('logs/commands.log');
        $directory = dirname($this->logFile);
        if (!is_dir($directory)) {
            @mkdir($directory, 0775, true);
        }
    }

    /**
     * @param array<string,mixed> $entry
     */
    public function log(array $entry): void
    {
        $record = $entry;
        $record['timestamp'] = $record['timestamp'] ?? gmdate('c');
        $payload = json_encode($record, JSON_UNESCAPED_SLASHES | JSON_UNESCAPED_UNICODE);
        if ($payload === false) {
            return;
        }
        @file_put_contents($this->logFile, $payload . PHP_EOL, FILE_APPEND);
    }
}
