<?php

declare(strict_types=1);

namespace Skyboard\Infrastructure\Mail;

use Skyboard;

final class LogMailer implements Mailer
{
    private string $logFile;

    public function __construct(?string $logFile = null)
    {
        $this->logFile = $logFile ?: Skyboard\storage_path('mail.log');
    }

    public function send(string $to, string $subject, string $textBody, ?string $htmlBody = null, array $headers = []): bool
    {
        // Conformité: ne pas logguer le contenu du message (éviter d'exposer des tokens).
        $entry = sprintf(
            "%s to=%s subject=%s headers=%s\n",
            gmdate('c'),
            $to,
            str_replace(["\n", "\r"], ' ', $subject),
            json_encode(array_keys($headers), JSON_UNESCAPED_UNICODE | JSON_UNESCAPED_SLASHES)
        );
        @file_put_contents($this->logFile, $entry, FILE_APPEND);
        return true; // Stub clair: considéré comme envoyé
    }
}

